/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ocean.rawsdk;

import com.alibaba.ocean.rawsdk.client.APIId;
import com.alibaba.ocean.rawsdk.client.AlibabaClientFactory;
import com.alibaba.ocean.rawsdk.client.Request;
import com.alibaba.ocean.rawsdk.client.SDKListener;
import com.alibaba.ocean.rawsdk.client.SyncAPIClient;
import com.alibaba.ocean.rawsdk.client.entity.AuthorizationToken;
import com.alibaba.ocean.rawsdk.client.entity.AuthorizationTokenStore;
import com.alibaba.ocean.rawsdk.client.entity.DefaultAuthorizationTokenStore;
import com.alibaba.ocean.rawsdk.client.exception.OceanException;
import com.alibaba.ocean.rawsdk.client.http.InvokeContext;
import com.alibaba.ocean.rawsdk.client.http.mapi.MapiResult;
import com.alibaba.ocean.rawsdk.client.http.mapi.SyncMapiClient;
import com.alibaba.ocean.rawsdk.client.policy.ClientPolicy;
import com.alibaba.ocean.rawsdk.client.policy.RequestPolicy;
import com.alibaba.ocean.rawsdk.client.serialize.DeSerializerListener;
import com.alibaba.ocean.rawsdk.client.serialize.SerializerListener;
import com.alibaba.ocean.rawsdk.common.AbstractAPIRequest;
import com.alibaba.ocean.rawsdk.common.SDKResult;
import java.net.Proxy;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ApiExecutor
implements SDKListener {
    private String serverHost = "gw.open.1688.com";
    private int httpPort = 80;
    private int httpsPort = 443;
    private String appKey;
    private String secKey;
    private int timeout;
    private int connectTimeout;
    private Proxy proxy;
    private AuthorizationTokenStore authorizationTokenStore;
    private Map<Class<? extends SerializerListener>, SerializerListener> serializerListeners = new LinkedHashMap<Class<? extends SerializerListener>, SerializerListener>();
    private Map<Class<? extends DeSerializerListener>, DeSerializerListener> deSerializerListeners = new LinkedHashMap<Class<? extends DeSerializerListener>, DeSerializerListener>();
    private volatile SyncAPIClient syncAPIClient;
    private volatile SyncMapiClient syncMAPIClient;

    public ApiExecutor(String appKey, String secKey) {
        this.appKey = appKey;
        this.secKey = secKey;
    }

    public ApiExecutor(String appKey, String secKey, Proxy proxy) {
        this.appKey = appKey;
        this.secKey = secKey;
        this.proxy = proxy;
    }

    public ApiExecutor(String serverHost, int httpPort, int httpsPort, String appKey, String secKey) {
        this.serverHost = serverHost;
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
        this.appKey = appKey;
        this.secKey = secKey;
    }

    public ApiExecutor(String serverHost, int httpPort, int httpsPort, String appKey, String secKey, Proxy proxy) {
        this.serverHost = serverHost;
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
        this.appKey = appKey;
        this.secKey = secKey;
        this.proxy = proxy;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public void register(SerializerListener serializerListener) {
        this.serializerListeners.put(serializerListener.getClass(), serializerListener);
    }

    @Override
    public void register(DeSerializerListener deSerializerListener) {
        this.deSerializerListeners.put(deSerializerListener.getClass(), deSerializerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyncAPIClient getAPIClient() {
        ClientPolicy clientPolicy = new ClientPolicy(this.serverHost);
        clientPolicy.setHttpPort(this.httpPort);
        clientPolicy.setHttpsPort(this.httpsPort);
        clientPolicy.setConnectTimeout(this.connectTimeout);
        clientPolicy.setTimeout(this.timeout);
        if (this.appKey != null) {
            clientPolicy.setAppKey(this.appKey);
        }
        if (this.secKey != null) {
            clientPolicy.setSigningKey(this.secKey);
        }
        if (this.proxy != null) {
            clientPolicy.setProxy(this.proxy);
        }
        if (this.authorizationTokenStore == null) {
            this.authorizationTokenStore = new DefaultAuthorizationTokenStore();
        }
        if (this.syncAPIClient == null) {
            ApiExecutor apiExecutor = this;
            synchronized (apiExecutor) {
                if (this.syncAPIClient == null) {
                    this.syncAPIClient = new AlibabaClientFactory().createAPIClient(clientPolicy, this.authorizationTokenStore);
                }
            }
        }
        return this.syncAPIClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyncMapiClient getMAPIClient() {
        ClientPolicy clientPolicy = new ClientPolicy(this.serverHost);
        clientPolicy.setHttpPort(this.httpPort);
        clientPolicy.setHttpsPort(this.httpsPort);
        if (this.appKey != null) {
            clientPolicy.setAppKey(this.appKey);
        }
        if (this.secKey != null) {
            clientPolicy.setSigningKey(this.secKey);
        }
        if (this.authorizationTokenStore == null) {
            this.authorizationTokenStore = new DefaultAuthorizationTokenStore();
        }
        if (this.syncMAPIClient == null) {
            ApiExecutor apiExecutor = this;
            synchronized (apiExecutor) {
                if (this.syncMAPIClient == null) {
                    this.syncMAPIClient = new AlibabaClientFactory().createMAPIClient(clientPolicy, this.authorizationTokenStore);
                }
            }
        }
        return this.syncMAPIClient;
    }

    public final AuthorizationToken getToken(String code) {
        try {
            return this.getAPIClient().getToken(code);
        }
        catch (OceanException e) {
            throw new RuntimeException(e.getErrorMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public final AuthorizationToken refreshToken(String refreshToken) {
        try {
            return this.getAPIClient().refreshToken(refreshToken);
        }
        catch (OceanException e) {
            throw new RuntimeException(e.getErrorMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public final <TResponse> SDKResult<TResponse> execute(AbstractAPIRequest<TResponse> apiRequest) {
        RequestPolicy reqPolicy = apiRequest.getOceanRequestPolicy();
        InvokeContext context = new InvokeContext();
        try {
            APIId apiId = apiRequest.getOceanApiId();
            Request req = new Request(apiId.getNamespace(), apiId.getName(), apiId.getVersion());
            req.setTraceId(apiRequest.getTraceId());
            req.setRpcId(apiRequest.getRpcId());
            req.setRequestEntity(apiRequest);
            TResponse ret = this.getAPIClient().send(req, apiRequest.getResponseClass(), reqPolicy, this.serializerListeners.values(), this.deSerializerListeners.values(), context);
            return this.buildSdkResult(ret, context, null, null, null);
        }
        catch (OceanException e) {
            if (e.getErrorCode() == null) {
                return this.buildSdkResult(null, context, "UNKNOWN_ERROR", e.getErrorMessage(), e);
            }
            return this.buildSdkResult(null, context, e.getErrorCode(), e.getErrorMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final <TResponse> SDKResult<TResponse> execute(AbstractAPIRequest<TResponse> apiRequest, String accessToken) {
        RequestPolicy reqPolicy = apiRequest.getOceanRequestPolicy();
        InvokeContext context = new InvokeContext();
        try {
            APIId apiId = apiRequest.getOceanApiId();
            Request req = new Request(apiId.getNamespace(), apiId.getName(), apiId.getVersion());
            req.setRequestEntity(apiRequest);
            req.setAccessToken(accessToken);
            req.setTraceId(apiRequest.getTraceId());
            req.setRpcId(apiRequest.getRpcId());
            TResponse ret = this.getAPIClient().send(req, apiRequest.getResponseClass(), reqPolicy, this.serializerListeners.values(), this.deSerializerListeners.values(), context);
            return this.buildSdkResult(ret, context, null, null, null);
        }
        catch (OceanException e) {
            if (e.getErrorCode() == null) {
                return this.buildSdkResult(null, context, "UNKNOWN_ERROR", e.getErrorMessage(), e);
            }
            return this.buildSdkResult(null, context, e.getErrorCode(), e.getErrorMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <TResponse> SDKResult<TResponse> buildSdkResult(TResponse ret, InvokeContext context, String errorCode, String errorMessage, OceanException e) {
        SDKResult<TResponse> result = new SDKResult<TResponse>();
        result.setErrorCode(errorCode);
        result.setErrorMessage(errorMessage);
        result.setResult(ret);
        if (context != null && context.getResponse() != null) {
            if (context.getResponse().getRequestId() != null) {
                result.setRequestId(context.getResponse().getRequestId());
            }
            if (context.getResponse().getTraceId() != null) {
                result.setTraceId(context.getResponse().getTraceId());
            }
        }
        if (e != null && e.getRequestId() != null && e.getTraceId() != null) {
            result.setRequestId(e.getRequestId());
            result.setTraceId(e.getTraceId());
        }
        return result;
    }

    public final <TResponse> SDKResult<MapiResult<TResponse>> mapiExecute(AbstractAPIRequest<TResponse> apiRequest, String accessToken) {
        RequestPolicy reqPolicy = apiRequest.getOceanRequestPolicy();
        try {
            APIId apiId = apiRequest.getOceanApiId();
            Request req = new Request(apiId.getNamespace(), apiId.getName(), apiId.getVersion());
            req.setRequestEntity(apiRequest);
            if (accessToken != null) {
                req.setAccessToken(accessToken);
            }
            MapiResult<TResponse> ret = this.getMAPIClient().mapiSend(req, apiRequest.getResponseClass(), reqPolicy, this.serializerListeners.values(), this.deSerializerListeners.values());
            return new SDKResult<MapiResult<TResponse>>(ret);
        }
        catch (OceanException e) {
            return new SDKResult<MapiResult<TResponse>>(e.getErrorCode(), e.getErrorMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

