/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ocean.rawsdk.client.http;

import com.alibaba.ocean.rawsdk.client.Request;
import com.alibaba.ocean.rawsdk.client.http.InvokeContext;
import com.alibaba.ocean.rawsdk.client.policy.ClientPolicy;
import com.alibaba.ocean.rawsdk.client.policy.RequestPolicy;
import com.alibaba.ocean.rawsdk.client.serialize.Serializer;
import com.alibaba.ocean.rawsdk.util.GenericsUtil;
import com.alibaba.ocean.rawsdk.util.SignatureUtil;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class HttpSupport {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final char QUERY_STRING_SEPARATOR = '?';
    public static final char PARAMETER_SEPARATOR = '&';
    public static final char NAME_VALUE_SEPARATOR = '=';
    public static final String PARAM_NAME_SIGNATURE = "_aop_signature";
    public static final String PARAM_NAME_TIMESTAMP = "_aop_timestamp";
    public static final String PARAM_NAME_DATEPATTERN = "_aop_datePattern";
    public static final String PARAM_NAME_RESPONSE_FORMAT = "_aop_responseFormat";
    public static final String PARAM_NAME_ACCESS_TOKEY = "access_token";

    public static final Map<String, String> buildHttpHeader(InvokeContext context, ClientPolicy clientPolicy) {
        LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
        header.put("Accept", "text/xml,text/javascript,application/json");
        header.put("User-Agent", clientPolicy.getAgent());
        if (context.getRequest() != null && context.getRequest().getTraceId() != null) {
            header.put("EagleEye-TraceId", context.getRequest().getTraceId());
            if (context.getRequest().getRpcId() != null) {
                header.put("EagleEye-RpcId", context.getRequest().getTraceId());
            }
        }
        return header;
    }

    public static final StringBuilder getApiRequestPath(RequestPolicy requestPolicy) {
        StringBuilder path = new StringBuilder();
        if (requestPolicy.isAccessPrivateApi()) {
            path.append("/api");
        } else {
            path.append("/openapi");
        }
        return path;
    }

    public static StringBuilder getProtocolRequestPath(InvokeContext context, ClientPolicy clientPolicy) {
        StringBuilder path = new StringBuilder();
        path.append(context.getPolicy().getRequestProtocol().name()).append('/');
        Request request = context.getRequest();
        if (request.getApiId().getVersion() < 0) {
            path.append(context.getPolicy().getDefaultApiVersion());
        } else {
            path.append(request.getApiId().getVersion());
        }
        path.append('/').append(request.getApiId().getNamespace()).append('/').append(request.getApiId().getName());
        if (clientPolicy.getAppKey() != null) {
            path.append('/').append(clientPolicy.getAppKey());
        }
        return path;
    }

    public static Map<String, Object> buildParams(Serializer serializer, InvokeContext context) {
        Map<String, Object> serializerMap = serializer.serialize(context.getRequest().getRequestEntity());
        serializerMap.putAll(context.getRequest().getAddtionalParams());
        RequestPolicy requestPolicy = context.getPolicy();
        if (!requestPolicy.getRequestProtocol().equals((Object)requestPolicy.getResponseProtocol())) {
            serializerMap.put(PARAM_NAME_RESPONSE_FORMAT, requestPolicy.getResponseProtocol().name());
        }
        if (requestPolicy.isRequestSendTimestamp()) {
            serializerMap.put(PARAM_NAME_TIMESTAMP, System.currentTimeMillis());
        }
        if (requestPolicy.getDateFormat() != null) {
            serializerMap.put(PARAM_NAME_DATEPATTERN, requestPolicy.getDateFormat());
        } else {
            serializerMap.put(PARAM_NAME_DATEPATTERN, "yyyy-MM-dd HH:mm:ss.SSS");
        }
        return serializerMap;
    }

    public static void signature(StringBuilder protocolRequestPath, Map<String, Object> parameters, RequestPolicy requestPolicy, ClientPolicy clientPolicy) {
        if (!requestPolicy.isUseSignture()) {
            return;
        }
        if (GenericsUtil.isBlank(clientPolicy.getAppKey()) || clientPolicy.getSigningKey() == null) {
            return;
        }
        byte[] sign = SignatureUtil.hmacSha1(protocolRequestPath.toString(), parameters, clientPolicy.getSigningKey());
        String signedContent = SignatureUtil.encodeHexStr(sign);
        parameters.put(PARAM_NAME_SIGNATURE, signedContent);
    }

    public static String buildQuery(Map<String, Object> params) throws IOException {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, Object>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, Object> entry : entries) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(String.valueOf(value), "utf-8"));
        }
        return query.toString();
    }

    public static URL buildGetRequestUrl(ClientPolicy clientPolicy, InvokeContext context, Map<String, Object> params) throws IOException {
        String protocol = "http";
        String host = clientPolicy.getServerHost();
        int port = clientPolicy.getHttpPort();
        if (context.getPolicy().isUseHttps()) {
            protocol = "https";
            port = clientPolicy.getHttpsPort();
        }
        StringBuilder pathSB = HttpSupport.getApiRequestPath(context.getPolicy());
        StringBuilder proptolRequestPath = HttpSupport.getProtocolRequestPath(context, clientPolicy);
        pathSB.append("/").append(proptolRequestPath.toString());
        String query = HttpSupport.buildQuery(params);
        if (!GenericsUtil.isBlank(query)) {
            pathSB.append("?");
            pathSB.append(query);
        }
        return new URL(protocol, host, port, pathSB.toString());
    }

    public static URL buildPostRequestUrl(ClientPolicy clientPolicy, InvokeContext context, Map<String, Object> params) throws IOException {
        String protocol = "http";
        String host = clientPolicy.getServerHost();
        int port = clientPolicy.getHttpPort();
        if (context.getPolicy().isUseHttps()) {
            protocol = "https";
            port = clientPolicy.getHttpsPort();
        }
        StringBuilder pathSB = HttpSupport.getApiRequestPath(context.getPolicy());
        StringBuilder proptolRequestPath = HttpSupport.getProtocolRequestPath(context, clientPolicy);
        pathSB.append("/").append(proptolRequestPath.toString());
        return new URL(protocol, host, port, pathSB.toString());
    }

    public static String parseResponseCharset(RequestPolicy requestPolicy, String ctype) {
        String charset = requestPolicy.getContentCharset();
        if (!GenericsUtil.isBlank(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || GenericsUtil.isBlank(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }
}

