/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ocean.rawsdk.client.http.mapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.ocean.rawsdk.client.Response;
import com.alibaba.ocean.rawsdk.client.http.HttpResponseBuilder;
import com.alibaba.ocean.rawsdk.client.http.InvokeContext;
import com.alibaba.ocean.rawsdk.client.http.mapi.MapiHttpSupport;
import com.alibaba.ocean.rawsdk.client.policy.ClientPolicy;
import com.alibaba.ocean.rawsdk.client.policy.Protocol;
import com.alibaba.ocean.rawsdk.client.serialize.DeSerializerListener;
import com.alibaba.ocean.rawsdk.client.serialize.Serializer;
import com.alibaba.ocean.rawsdk.client.serialize.SerializerListener;
import com.alibaba.ocean.rawsdk.client.serialize.SerializerProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class MapiHttpClient {
    private SerializerProvider serializerProvider;
    private HttpResponseBuilder responseBuilder;

    public MapiHttpClient(SerializerProvider serializerProvider, HttpResponseBuilder responseBuilder) {
        this.serializerProvider = serializerProvider;
        this.responseBuilder = responseBuilder;
    }

    public Response request(InvokeContext invokeContext, ClientPolicy clientPolicy, Collection<SerializerListener> serializerListners, Collection<DeSerializerListener> deSerializerListners) throws IOException {
        StringBuilder requestPath = MapiHttpSupport.getProtocolRequestPath(invokeContext, clientPolicy);
        Protocol protocol = invokeContext.getPolicy().getRequestProtocol();
        Serializer serializer = this.serializerProvider.getSerializer(protocol.name());
        for (SerializerListener serializerListener : serializerListners) {
            serializer.registeSerializerListener(serializerListener);
        }
        Map<String, Object> parameters = MapiHttpSupport.buildParams(serializer, invokeContext);
        byte[] paramBytes = this.getParamBytes(parameters, invokeContext);
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String queryString = MapiHttpSupport.getQueryString(timeStamp, invokeContext);
        String signature = MapiHttpSupport.getSignature(requestPath.toString(), queryString, paramBytes, invokeContext, clientPolicy);
        URL postURL = MapiHttpSupport.buildFinalRequestUrl(clientPolicy, invokeContext, requestPath.toString(), queryString);
        Response response = this.doPost(postURL, paramBytes, signature, invokeContext, clientPolicy, deSerializerListners);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response doPost(URL url, byte[] contentBody, String signature, InvokeContext invokeContext, ClientPolicy clientPolicy, Collection<DeSerializerListener> deSerializerListners) {
        HttpURLConnection conn = null;
        OutputStream out = null;
        Response response = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            Map<String, String> clientHttpHeader = MapiHttpSupport.buildHttpHeader(invokeContext, clientPolicy);
            for (Map.Entry<String, String> entry : clientHttpHeader.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
            conn.setRequestProperty("X-Sign-HMAC", signature);
            out = conn.getOutputStream();
            out.write(contentBody);
            int httpCode = conn.getResponseCode();
            String contentEncoding = conn.getContentEncoding();
            String contentType = conn.getContentType();
            InputStream inputStream = null;
            inputStream = httpCode >= 200 && httpCode <= 299 ? conn.getInputStream() : conn.getErrorStream();
            response = this.getResponseBuilder().buildResponse(inputStream, httpCode, contentEncoding, contentType, invokeContext, deSerializerListners);
        }
        catch (Exception e) {
            response.setException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {}
            if (conn != null) {
                conn.disconnect();
            }
        }
        return response;
    }

    private byte[] getParamBytes(Map<String, Object> parameters, InvokeContext invokeContext) {
        String ce = invokeContext.getPolicy().getRequestContentEncoding();
        byte[] body = JSON.toJSONBytes(parameters, (SerializerFeature[])new SerializerFeature[0]);
        if ("gzip".equals(ce)) {
            return this.gzipCompressByte(body);
        }
        if ("deflate".equals(ce)) {
            return this.deflateCompressByte(body);
        }
        return body;
    }

    private byte[] gzipCompressByte(byte[] body) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(body);
            gzip.close();
        }
        catch (IOException e) {
            return null;
        }
        return out.toByteArray();
    }

    private byte[] deflateCompressByte(byte[] body) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            DeflaterOutputStream deflate = new DeflaterOutputStream(out);
            deflate.write(body);
            deflate.close();
        }
        catch (IOException e) {
            return null;
        }
        return out.toByteArray();
    }

    public SerializerProvider getSerializerProvider() {
        return this.serializerProvider;
    }

    public HttpResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }
}

