/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ocean.rawsdk.client.imp.serialize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.ocean.rawsdk.client.entity.ResponseStatus;
import com.alibaba.ocean.rawsdk.client.entity.ResponseWrapper;
import com.alibaba.ocean.rawsdk.client.imp.serialize.AbstractJsonDeserializer;
import com.alibaba.ocean.rawsdk.client.imp.serialize.OpenPlatformDateCodec;
import com.alibaba.ocean.rawsdk.client.policy.Protocol;
import com.alibaba.ocean.rawsdk.client.serialize.DeSerializerListener;
import com.alibaba.ocean.rawsdk.client.util.ExceptionParser;
import java.util.Date;
import java.util.Map;

public class JsonDeserializer
extends AbstractJsonDeserializer {
    @Override
    public String supportedContentType() {
        return Protocol.json.name();
    }

    @Override
    public <T> ResponseWrapper<T> deSerialize(String content, Class<T> resultType) {
        ResponseWrapper<Object> responseWrapper = new ResponseWrapper<Object>();
        JSONObject rootJson = JSON.parseObject((String)content);
        responseWrapper.setInvokeStartTime(rootJson.getString("InvokeStartTime"));
        responseWrapper.setInvokeCostTime(rootJson.getLongValue("InvokeCostTime"));
        JSONObject statusJson = rootJson.getJSONObject("Status");
        ResponseStatus responseStatus = this.parseResult(statusJson, ResponseStatus.class);
        responseWrapper.setStatus(responseStatus);
        JSONArray jsonResponseArray = rootJson.getJSONArray("Responses");
        JSONObject jsonResponseObject = jsonResponseArray.getJSONObject(0);
        ParserConfig config = ParserConfig.getGlobalInstance();
        config.putDeserializer(Date.class, (ObjectDeserializer)OpenPlatformDateCodec.instance);
        Object result = JSON.parseObject((String)jsonResponseObject.toJSONString(), resultType, (ParserConfig)config, null, (int)JSON.DEFAULT_PARSER_FEATURE, (Feature[])new Feature[0]);
        responseWrapper.setResult(result);
        return responseWrapper;
    }

    @Override
    public Throwable buildException(String content, int statusCode) {
        Map result = (Map)JSON.parseObject((String)content, Map.class);
        return ExceptionParser.buildException4Json2(result);
    }

    @Override
    public void registeDeSerializerListener(DeSerializerListener listner) {
    }
}

