/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ocean.rawsdk.client.policy;

import java.net.Proxy;

public class ClientPolicy
implements Cloneable {
    private static Integer DEFAULT_HTTP_PORT = 80;
    private static Integer DEFAULT_HTTPS_PORT = 443;
    private static final ClientPolicy CBU_POLICY = new ClientPolicy("gw.open.1688.com");
    private String serverHost;
    private int httpPort = DEFAULT_HTTP_PORT;
    private int httpsPort = DEFAULT_HTTPS_PORT;
    private String appKey;
    private String signingKey;
    private String defaultContentCharset = "UTF-8";
    private boolean defaultUseHttps = false;
    private String agent = "Ocean-SDK-Client";
    private Proxy proxy;
    private int timeout;
    private int connectTimeout;

    public static ClientPolicy getDefaultChinaAlibabaPolicy() {
        return CBU_POLICY.clone();
    }

    public ClientPolicy clone() {
        ClientPolicy newObj = this.newPolicy();
        newObj.httpPort = this.httpPort;
        newObj.httpsPort = this.httpsPort;
        newObj.timeout = this.timeout;
        newObj.connectTimeout = this.connectTimeout;
        newObj.defaultContentCharset = this.defaultContentCharset;
        newObj.defaultUseHttps = this.defaultUseHttps;
        newObj.appKey = this.appKey;
        newObj.signingKey = this.signingKey;
        newObj.agent = this.agent;
        return newObj;
    }

    protected ClientPolicy newPolicy() {
        return new ClientPolicy(this.serverHost);
    }

    public ClientPolicy(String serverHost) {
        if (serverHost == null || serverHost.length() < 1) {
            throw new IllegalArgumentException("serverHost can not be empty");
        }
        this.serverHost = serverHost;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public ClientPolicy setHttpPort(Integer httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    public ClientPolicy setHttpsPort(Integer httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public ClientPolicy setAppKey(String appKey) {
        this.appKey = appKey;
        return this;
    }

    public String getSigningKey() {
        return this.signingKey;
    }

    public ClientPolicy setSigningKey(String signingKey) {
        this.signingKey = signingKey;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public ClientPolicy setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public ClientPolicy setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public String getDefaultContentCharset() {
        return this.defaultContentCharset;
    }

    public ClientPolicy setDefaultContentCharset(String defaultContentCharset) {
        this.defaultContentCharset = defaultContentCharset;
        return this;
    }

    public boolean isDefaultUseHttps() {
        return this.defaultUseHttps;
    }

    public ClientPolicy setDefaultUseHttps(boolean defaultUseHttps) {
        this.defaultUseHttps = defaultUseHttps;
        return this;
    }

    public String getAgent() {
        return this.agent;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public ClientPolicy setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }
}

