package cn.alibaba.open.param;

import java.util.*;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AlibabaCaigouCoopapiBiddingParamBiddingRequirementParam {

    private Boolean allowPartOffer;

    /**
     * @return 允许对询价单商品部分报价
     */
    public Boolean getAllowPartOffer() {
        return allowPartOffer;
    }

    /**
     * 设置允许对询价单商品部分报价     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setAllowPartOffer(Boolean allowPartOffer) {
        this.allowPartOffer = allowPartOffer;
    }

    private String balanceDateType;

    /**
     * @return 账期结算的结算日期类型
     */
    public String getBalanceDateType() {
        return balanceDateType;
    }

    /**
     * 设置账期结算的结算日期类型     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setBalanceDateType(String balanceDateType) {
        this.balanceDateType = balanceDateType;
    }

    private String balanceDateValue;

    /**
     * @return 账期结算的结算日期值
     */
    public String getBalanceDateValue() {
        return balanceDateValue;
    }

    /**
     * 设置账期结算的结算日期值     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setBalanceDateValue(String balanceDateValue) {
        this.balanceDateValue = balanceDateValue;
    }

    private String biddingAnnounce;

    /**
     * @return 招标公告
     */
    public String getBiddingAnnounce() {
        return biddingAnnounce;
    }

    /**
     * 设置招标公告     *
     * 参数示例：<pre>按需填写</pre>     
     * 此参数必填
     */
    public void setBiddingAnnounce(String biddingAnnounce) {
        this.biddingAnnounce = biddingAnnounce;
    }

    private String biddingChangeAnnounce;

    /**
     * @return 变更摘要
     */
    public String getBiddingChangeAnnounce() {
        return biddingChangeAnnounce;
    }

    /**
     * 设置变更摘要     *
     * 参数示例：<pre>按需填写</pre>     
     * 此参数必填
     */
    public void setBiddingChangeAnnounce(String biddingChangeAnnounce) {
        this.biddingChangeAnnounce = biddingChangeAnnounce;
    }

    private String biddingMethod;

    /**
     * @return 招标方式{open:公开；邀标: selectedmysupplier}
     */
    public String getBiddingMethod() {
        return biddingMethod;
    }

    /**
     * 设置招标方式{open:公开；邀标: selectedmysupplier}     *
     * 参数示例：<pre>open</pre>     
     * 此参数必填
     */
    public void setBiddingMethod(String biddingMethod) {
        this.biddingMethod = biddingMethod;
    }

    private String biddingOrgCode;

    /**
     * @return 招标单位的code
     */
    public String getBiddingOrgCode() {
        return biddingOrgCode;
    }

    /**
     * 设置招标单位的code     *
     * 参数示例：<pre>testCompany</pre>     
     * 此参数必填
     */
    public void setBiddingOrgCode(String biddingOrgCode) {
        this.biddingOrgCode = biddingOrgCode;
    }

    private String biddingOrgName;

    /**
     * @return 招标单位的名称
     */
    public String getBiddingOrgName() {
        return biddingOrgName;
    }

    /**
     * 设置招标单位的名称     *
     * 参数示例：<pre>testCompany</pre>     
     * 此参数必填
     */
    public void setBiddingOrgName(String biddingOrgName) {
        this.biddingOrgName = biddingOrgName;
    }

    private String biddingPlanCode;

    /**
     * @return 招标计划code，例如year、month
     */
    public String getBiddingPlanCode() {
        return biddingPlanCode;
    }

    /**
     * 设置招标计划code，例如year、month     *
     * 参数示例：<pre>year</pre>     
     * 此参数必填
     */
    public void setBiddingPlanCode(String biddingPlanCode) {
        this.biddingPlanCode = biddingPlanCode;
    }

    private String biddingPlanDesc;

    /**
     * @return 招标计划描述
     */
    public String getBiddingPlanDesc() {
        return biddingPlanDesc;
    }

    /**
     * 设置招标计划描述     *
     * 参数示例：<pre>根据实际情况填写</pre>     
     * 此参数必填
     */
    public void setBiddingPlanDesc(String biddingPlanDesc) {
        this.biddingPlanDesc = biddingPlanDesc;
    }

    private String biddingType;

    /**
     * @return 招标类型code:{service:服务；enginerring:工程；material:物资}
     */
    public String getBiddingType() {
        return biddingType;
    }

    /**
     * 设置招标类型code:{service:服务；enginerring:工程；material:物资}     *
     * 参数示例：<pre>enginerring</pre>     
     * 此参数必填
     */
    public void setBiddingType(String biddingType) {
        this.biddingType = biddingType;
    }

    private String biddingTypeName;

    /**
     * @return 招标类型的名称:{服务、工程、物资}
     */
    public String getBiddingTypeName() {
        return biddingTypeName;
    }

    /**
     * 设置招标类型的名称:{服务、工程、物资}     *
     * 参数示例：<pre>工程</pre>     
     * 此参数必填
     */
    public void setBiddingTypeName(String biddingTypeName) {
        this.biddingTypeName = biddingTypeName;
    }

    private String[] businessModels;

    /**
     * @return 经营模式{othe：其他;wholesale：经销分发;trade：商业服务;investment：招商代理;manufacturer：生产加工}
     */
    public String[] getBusinessModels() {
        return businessModels;
    }

    /**
     * 设置经营模式{othe：其他;wholesale：经销分发;trade：商业服务;investment：招商代理;manufacturer：生产加工}     *
     * 参数示例：<pre>["other","wholesale","trade","investment","manufacturer"]</pre>     
     * 此参数必填
     */
    public void setBusinessModels(String[] businessModels) {
        this.businessModels = businessModels;
    }

    private Long buyerUserId;

    /**
     * @return 用户ID
     */
    public Long getBuyerUserId() {
        return buyerUserId;
    }

    /**
     * 设置用户ID     *
     * 参数示例：<pre>1111</pre>     
     * 此参数必填
     */
    public void setBuyerUserId(Long buyerUserId) {
        this.buyerUserId = buyerUserId;
    }

    private String entrySource;

    /**
     * @return 来源
     */
    public String getEntrySource() {
        return entrySource;
    }

    /**
     * 设置来源     *
     * 参数示例：<pre>work</pre>     
     * 此参数必填
     */
    public void setEntrySource(String entrySource) {
        this.entrySource = entrySource;
    }

    private String fundsSource;

    /**
     * @return 资金来源
     */
    public String getFundsSource() {
        return fundsSource;
    }

    /**
     * 设置资金来源     *
     * 参数示例：<pre>贷款</pre>     
     * 此参数必填
     */
    public void setFundsSource(String fundsSource) {
        this.fundsSource = fundsSource;
    }

    private String gmtApplyStart;

    /**
     * @return 报名开始时间(yyyy-MM-dd HH:mm:ss)
     */
    public String getGmtApplyStart() {
        return gmtApplyStart;
    }

    /**
     * 设置报名开始时间(yyyy-MM-dd HH:mm:ss)     *
     * 参数示例：<pre>2020-12-01 00:00:00</pre>     
     * 此参数必填
     */
    public void setGmtApplyStart(String gmtApplyStart) {
        this.gmtApplyStart = gmtApplyStart;
    }

    private String gmtApplyExpire;

    /**
     * @return 报名结束时间(yyyy-MM-dd HH:mm:ss)
     */
    public String getGmtApplyExpire() {
        return gmtApplyExpire;
    }

    /**
     * 设置报名结束时间(yyyy-MM-dd HH:mm:ss)     *
     * 参数示例：<pre>2020-12-01 00:00:00</pre>     
     * 此参数必填
     */
    public void setGmtApplyExpire(String gmtApplyExpire) {
        this.gmtApplyExpire = gmtApplyExpire;
    }

    private String gmtEvaluateStart;

    /**
     * @return 评标开始时间(yyyy-MM-dd HH:mm:ss)
     */
    public String getGmtEvaluateStart() {
        return gmtEvaluateStart;
    }

    /**
     * 设置评标开始时间(yyyy-MM-dd HH:mm:ss)     *
     * 参数示例：<pre>2020-12-01 00:00:00</pre>     
     * 此参数必填
     */
    public void setGmtEvaluateStart(String gmtEvaluateStart) {
        this.gmtEvaluateStart = gmtEvaluateStart;
    }

    private String gmtEvaluateEnd;

    /**
     * @return 评标结束时间(yyyy-MM-dd HH:mm:ss)
     */
    public String getGmtEvaluateEnd() {
        return gmtEvaluateEnd;
    }

    /**
     * 设置评标结束时间(yyyy-MM-dd HH:mm:ss)     *
     * 参数示例：<pre>2020-12-01 00:00:00</pre>     
     * 此参数必填
     */
    public void setGmtEvaluateEnd(String gmtEvaluateEnd) {
        this.gmtEvaluateEnd = gmtEvaluateEnd;
    }

    private String gmtOpenStart;

    /**
     * @return 开标开始时间(yyyy-MM-dd HH:mm:ss)
     */
    public String getGmtOpenStart() {
        return gmtOpenStart;
    }

    /**
     * 设置开标开始时间(yyyy-MM-dd HH:mm:ss)     *
     * 参数示例：<pre>2020-12-01 00:00:00</pre>     
     * 此参数必填
     */
    public void setGmtOpenStart(String gmtOpenStart) {
        this.gmtOpenStart = gmtOpenStart;
    }

    private String gmtOpenEnd;

    /**
     * @return 开标结束时间(yyyy-MM-dd HH:mm:ss)
     */
    public String getGmtOpenEnd() {
        return gmtOpenEnd;
    }

    /**
     * 设置开标结束时间(yyyy-MM-dd HH:mm:ss)     *
     * 参数示例：<pre>2020-12-01 00:00:00</pre>     
     * 此参数必填
     */
    public void setGmtOpenEnd(String gmtOpenEnd) {
        this.gmtOpenEnd = gmtOpenEnd;
    }

    private String gmtQuotationStart;

    /**
     * @return 投标开始时间(yyyy-MM-dd HH:mm:ss)
     */
    public String getGmtQuotationStart() {
        return gmtQuotationStart;
    }

    /**
     * 设置投标开始时间(yyyy-MM-dd HH:mm:ss)     *
     * 参数示例：<pre>2020-12-01 00:00:00</pre>     
     * 此参数必填
     */
    public void setGmtQuotationStart(String gmtQuotationStart) {
        this.gmtQuotationStart = gmtQuotationStart;
    }

    private String gmtQuotationExpire;

    /**
     * @return 投标截止时间(yyyy-MM-dd HH:mm:ss)
     */
    public String getGmtQuotationExpire() {
        return gmtQuotationExpire;
    }

    /**
     * 设置投标截止时间(yyyy-MM-dd HH:mm:ss)     *
     * 参数示例：<pre>2020-12-01 00:00:00</pre>     
     * 此参数必填
     */
    public void setGmtQuotationExpire(String gmtQuotationExpire) {
        this.gmtQuotationExpire = gmtQuotationExpire;
    }

    private String guaranteeAmountStr;

    /**
     * @return 保证金
     */
    public String getGuaranteeAmountStr() {
        return guaranteeAmountStr;
    }

    /**
     * 设置保证金     *
     * 参数示例：<pre>1000</pre>     
     * 此参数必填
     */
    public void setGuaranteeAmountStr(String guaranteeAmountStr) {
        this.guaranteeAmountStr = guaranteeAmountStr;
    }

    private Boolean includeTax;

    /**
     * @return 是否包含税价
     */
    public Boolean getIncludeTax() {
        return includeTax;
    }

    /**
     * 设置是否包含税价     *
     * 参数示例：<pre>false</pre>     
     * 此参数必填
     */
    public void setIncludeTax(Boolean includeTax) {
        this.includeTax = includeTax;
    }

    private String inviteSupplierMemberIds;

    /**
     * @return 定向邀请的供应商ID
     */
    public String getInviteSupplierMemberIds() {
        return inviteSupplierMemberIds;
    }

    /**
     * 设置定向邀请的供应商ID     *
     * 参数示例：<pre>2740020819</pre>     
     * 此参数必填
     */
    public void setInviteSupplierMemberIds(String inviteSupplierMemberIds) {
        this.inviteSupplierMemberIds = inviteSupplierMemberIds;
    }

    private String invoiceSubType;

    /**
     * @return 税务发票子类型:{self:自行开票; agent: 税务代开}
     */
    public String getInvoiceSubType() {
        return invoiceSubType;
    }

    /**
     * 设置税务发票子类型:{self:自行开票; agent: 税务代开}     *
     * 参数示例：<pre>self</pre>     
     * 此参数必填
     */
    public void setInvoiceSubType(String invoiceSubType) {
        this.invoiceSubType = invoiceSubType;
    }

    private String invoiceType;

    /**
     * @return 发票类型:{common:普通发票;vat:增值发票;no:不提供发票}
     */
    public String getInvoiceType() {
        return invoiceType;
    }

    /**
     * 设置发票类型:{common:普通发票;vat:增值发票;no:不提供发票}     *
     * 参数示例：<pre>no</pre>     
     * 此参数必填
     */
    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    private Boolean needAlipay;

    /**
     * @return 是否需要支付宝
     */
    public Boolean getNeedAlipay() {
        return needAlipay;
    }

    /**
     * 设置是否需要支付宝     *
     * 参数示例：<pre>false</pre>     
     * 此参数必填
     */
    public void setNeedAlipay(Boolean needAlipay) {
        this.needAlipay = needAlipay;
    }

    private Boolean onlyInvited;

    /**
     * @return 只允许邀请供应商参与
     */
    public Boolean getOnlyInvited() {
        return onlyInvited;
    }

    /**
     * 设置只允许邀请供应商参与     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setOnlyInvited(Boolean onlyInvited) {
        this.onlyInvited = onlyInvited;
    }

    private Boolean open;

    /**
     * @return 公开招标
     */
    public Boolean getOpen() {
        return open;
    }

    /**
     * 设置公开招标     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setOpen(Boolean open) {
        this.open = open;
    }

    private String openBiddingMethod;

    /**
     * @return 开标方法
     */
    public String getOpenBiddingMethod() {
        return openBiddingMethod;
    }

    /**
     * 设置开标方法     *
     * 参数示例：<pre>one</pre>     
     * 此参数必填
     */
    public void setOpenBiddingMethod(String openBiddingMethod) {
        this.openBiddingMethod = openBiddingMethod;
    }

    private String payType;

    /**
     * @return 支付方式
     */
    public String getPayType() {
        return payType;
    }

    /**
     * 设置支付方式     *
     * 参数示例：<pre>{"alipay":false,"payperiod":false,"payperiodType":"specify","payperiodDays":"17","steppay":true,"steppayType":"stepTrade91BusinessBuy","steppayDays":"180","other":false,"otherDesc":""}</pre>     
     * 此参数必填
     */
    public void setPayType(String payType) {
        this.payType = payType;
    }

    private String protocolBeginDate;

    /**
     * @return 价格有效期开始时间(yyyy-MM-dd HH:mm:ss)
     */
    public String getProtocolBeginDate() {
        return protocolBeginDate;
    }

    /**
     * 设置价格有效期开始时间(yyyy-MM-dd HH:mm:ss)     *
     * 参数示例：<pre>2020-12-01 00:00:00</pre>     
     * 此参数必填
     */
    public void setProtocolBeginDate(String protocolBeginDate) {
        this.protocolBeginDate = protocolBeginDate;
    }

    private String protocolEndDate;

    /**
     * @return 价格有效期结束时间(yyyy-MM-dd HH:mm:ss)
     */
    public String getProtocolEndDate() {
        return protocolEndDate;
    }

    /**
     * 设置价格有效期结束时间(yyyy-MM-dd HH:mm:ss)     *
     * 参数示例：<pre>2020-12-01 00:00:00</pre>     
     * 此参数必填
     */
    public void setProtocolEndDate(String protocolEndDate) {
        this.protocolEndDate = protocolEndDate;
    }

    private String publishChannel;

    /**
     * @return 发布渠道
     */
    public String getPublishChannel() {
        return publishChannel;
    }

    /**
     * 设置发布渠道     *
     * 参数示例：<pre>1688portal</pre>     
     * 此参数必填
     */
    public void setPublishChannel(String publishChannel) {
        this.publishChannel = publishChannel;
    }

    private String purchaseBudget;

    /**
     * @return 采购预算（单位：分）
     */
    public String getPurchaseBudget() {
        return purchaseBudget;
    }

    /**
     * 设置采购预算（单位：分）     *
     * 参数示例：<pre>150000</pre>     
     * 此参数必填
     */
    public void setPurchaseBudget(String purchaseBudget) {
        this.purchaseBudget = purchaseBudget;
    }

    private String purchaseItemWriteParamStr;

    /**
     * @return 招标物料
     */
    public String getPurchaseItemWriteParamStr() {
        return purchaseItemWriteParamStr;
    }

    /**
     * 设置招标物料     *
     * 参数示例：<pre>[{"productId":"","purchaseNoteItemId":"","subject":"砖","productCode":"1234556","purchaseAmount":"10000","basePrice":"0.6","category":"201346017,1038388,1313","fullPathName":"","unit":"块","brandName":"AAA","modelNumber":"vv","productFeature":"xxxxcvasdfas","attachments":null,"prItemId":"","quoteUnit":""}]</pre>     
     * 此参数必填
     */
    public void setPurchaseItemWriteParamStr(String purchaseItemWriteParamStr) {
        this.purchaseItemWriteParamStr = purchaseItemWriteParamStr;
    }

    private String quotationRequirement;

    /**
     * @return 报价要求
     */
    public String getQuotationRequirement() {
        return quotationRequirement;
    }

    /**
     * 设置报价要求     *
     * 参数示例：<pre>["includeTax","quoteHasPostFee","allowPartOffer"]</pre>     
     * 此参数必填
     */
    public void setQuotationRequirement(String quotationRequirement) {
        this.quotationRequirement = quotationRequirement;
    }

    private Boolean quoteHasPostFee;

    /**
     * @return 报价需要包含运费价
     */
    public Boolean getQuoteHasPostFee() {
        return quoteHasPostFee;
    }

    /**
     * 设置报价需要包含运费价     *
     * 参数示例：<pre>false</pre>     
     * 此参数必填
     */
    public void setQuoteHasPostFee(Boolean quoteHasPostFee) {
        this.quoteHasPostFee = quoteHasPostFee;
    }

    private String receiveBeginDate;

    /**
     * @return 期望收货开始日期(yyyy-MM-dd HH:mm:ss)
     */
    public String getReceiveBeginDate() {
        return receiveBeginDate;
    }

    /**
     * 设置期望收货开始日期(yyyy-MM-dd HH:mm:ss)     *
     * 参数示例：<pre>2020-12-01 00:00:00</pre>     
     * 此参数必填
     */
    public void setReceiveBeginDate(String receiveBeginDate) {
        this.receiveBeginDate = receiveBeginDate;
    }

    private String receiveEndDate;

    /**
     * @return 期望收货结束日期(yyyy-MM-dd HH:mm:ss)
     */
    public String getReceiveEndDate() {
        return receiveEndDate;
    }

    /**
     * 设置期望收货结束日期(yyyy-MM-dd HH:mm:ss)     *
     * 参数示例：<pre>2020-12-01 00:00:00</pre>     
     * 此参数必填
     */
    public void setReceiveEndDate(String receiveEndDate) {
        this.receiveEndDate = receiveEndDate;
    }

    private Long registeredCapital;

    /**
     * @return 注册资金必须大于
     */
    public Long getRegisteredCapital() {
        return registeredCapital;
    }

    /**
     * 设置注册资金必须大于     *
     * 参数示例：<pre>1000</pre>     
     * 此参数必填
     */
    public void setRegisteredCapital(Long registeredCapital) {
        this.registeredCapital = registeredCapital;
    }

    private Boolean selectedmysupplier;

    /**
     * @return 邀请招标
     */
    public Boolean getSelectedmysupplier() {
        return selectedmysupplier;
    }

    /**
     * 设置邀请招标     *
     * 参数示例：<pre>false</pre>     
     * 此参数必填
     */
    public void setSelectedmysupplier(Boolean selectedmysupplier) {
        this.selectedmysupplier = selectedmysupplier;
    }

    private Boolean showMoreAddress;

    /**
     * @return 是否展示更多地址
     */
    public Boolean getShowMoreAddress() {
        return showMoreAddress;
    }

    /**
     * 设置是否展示更多地址     *
     * 参数示例：<pre>false</pre>     
     * 此参数必填
     */
    public void setShowMoreAddress(Boolean showMoreAddress) {
        this.showMoreAddress = showMoreAddress;
    }

    private String subBizType;

    /**
     * @return 采购类型:{singlepurchase：单次采购;priceprotocol：协议采购}
     */
    public String getSubBizType() {
        return subBizType;
    }

    /**
     * 设置采购类型:{singlepurchase：单次采购;priceprotocol：协议采购}     *
     * 参数示例：<pre>priceprotocol</pre>     
     * 此参数必填
     */
    public void setSubBizType(String subBizType) {
        this.subBizType = subBizType;
    }

    private String subject;

    /**
     * @return 招标名称
     */
    public String getSubject() {
        return subject;
    }

    /**
     * 设置招标名称     *
     * 参数示例：<pre>根据实际情况填写</pre>     
     * 此参数必填
     */
    public void setSubject(String subject) {
        this.subject = subject;
    }

    private Boolean supplierCanModifyQuantity;

    /**
     * @return 供应商报价可改数量
     */
    public Boolean getSupplierCanModifyQuantity() {
        return supplierCanModifyQuantity;
    }

    /**
     * 设置供应商报价可改数量     *
     * 参数示例：<pre>false</pre>     
     * 此参数必填
     */
    public void setSupplierCanModifyQuantity(Boolean supplierCanModifyQuantity) {
        this.supplierCanModifyQuantity = supplierCanModifyQuantity;
    }

    private Boolean supportSteppay;

    /**
     * @return 支持分阶段付款
     */
    public Boolean getSupportSteppay() {
        return supportSteppay;
    }

    /**
     * 设置支持分阶段付款     *
     * 参数示例：<pre>false</pre>     
     * 此参数必填
     */
    public void setSupportSteppay(Boolean supportSteppay) {
        this.supportSteppay = supportSteppay;
    }

    private String tradeDescription;

    /**
     * @return 交易要求：文本描述
     */
    public String getTradeDescription() {
        return tradeDescription;
    }

    /**
     * 设置交易要求：文本描述     *
     * 参数示例：<pre>按需填写</pre>     
     * 此参数必填
     */
    public void setTradeDescription(String tradeDescription) {
        this.tradeDescription = tradeDescription;
    }

    private String tradeMode;

    /**
     * @return 交易方式
     */
    public String getTradeMode() {
        return tradeMode;
    }

    /**
     * 设置交易方式     *
     * 参数示例：<pre>{"alipay":false,"payperiod":false,"payperiodType":"specify","payperiodDays":"17","steppay":true,"steppayType":"stepTrade91BusinessBuy","steppayDays":"180","other":false,"otherDesc":""}</pre>     
     * 此参数必填
     */
    public void setTradeMode(String tradeMode) {
        this.tradeMode = tradeMode;
    }

    private String tradeType;

    /**
     * @return 付款方式{"alipay","steppay","payperiod","other"}
     */
    public String getTradeType() {
        return tradeType;
    }

    /**
     * 设置付款方式{"alipay","steppay","payperiod","other"}     *
     * 参数示例：<pre>alipay</pre>     
     * 此参数必填
     */
    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    private String receiveDistrictCode;

    /**
     * @return 区编码
     */
    public String getReceiveDistrictCode() {
        return receiveDistrictCode;
    }

    /**
     * 设置区编码     *
     * 参数示例：<pre>3214</pre>     
     * 此参数必填
     */
    public void setReceiveDistrictCode(String receiveDistrictCode) {
        this.receiveDistrictCode = receiveDistrictCode;
    }

    private String streetAddress;

    /**
     * @return 详细地址
     */
    public String getStreetAddress() {
        return streetAddress;
    }

    /**
     * 设置详细地址     *
     * 参数示例：<pre>网商路699号</pre>     
     * 此参数必填
     */
    public void setStreetAddress(String streetAddress) {
        this.streetAddress = streetAddress;
    }

    private String number;

    /**
     * @return 招标编码，示例：ZB-20201130-00017，长度不得大于64位
     */
    public String getNumber() {
        return number;
    }

    /**
     * 设置招标编码，示例：ZB-20201130-00017，长度不得大于64位     *
     * 参数示例：<pre>ZB-20201130-00017</pre>     
     * 此参数必填
     */
    public void setNumber(String number) {
        this.number = number;
    }

    private Boolean acceptConsortiumBids;

    /**
     * @return 是否接受联合体投标(true:接受，false:不接受)
     */
    public Boolean getAcceptConsortiumBids() {
        return acceptConsortiumBids;
    }

    /**
     * 设置是否接受联合体投标(true:接受，false:不接受)     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setAcceptConsortiumBids(Boolean acceptConsortiumBids) {
        this.acceptConsortiumBids = acceptConsortiumBids;
    }

    private String industryCategoryCode;

    /**
     * @return 项目行业分类编码（如须项目行业分类编码与名称对照表，请联系开发人员）
     */
    public String getIndustryCategoryCode() {
        return industryCategoryCode;
    }

    /**
     * 设置项目行业分类编码（如须项目行业分类编码与名称对照表，请联系开发人员）     *
     * 参数示例：<pre>G11(项目行业分类编码)</pre>     
     * 此参数必填
     */
    public void setIndustryCategoryCode(String industryCategoryCode) {
        this.industryCategoryCode = industryCategoryCode;
    }

}
