package cn.alibaba.open.param;

import java.util.*;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AlibabaCaigouCoopapiBiddingParamsBiddingCreateParam {

    private String subject;

    /**
     * @return 招标名称
     */
    public String getSubject() {
        return subject;
    }

    /**
     * 设置招标名称     *
     * 参数示例：<pre>招标单测试</pre>     
     * 此参数必填
     */
    public void setSubject(String subject) {
        this.subject = subject;
    }

    private String number;

    /**
     * @return 招标单编号(系统会自动生成招标单编号，如果企业有对应的编码规则，直接给出值就好，64个字符以内)
     */
    public String getNumber() {
        return number;
    }

    /**
     * 设置招标单编号(系统会自动生成招标单编号，如果企业有对应的编码规则，直接给出值就好，64个字符以内)     *
     * 参数示例：<pre>ZB-20210519-00029</pre>     
     * 此参数必填
     */
    public void setNumber(String number) {
        this.number = number;
    }

    private String biddingMethod;

    /**
     * @return 招标方式:(selectedmysupplier：邀请招标 / open：公开招标)
     */
    public String getBiddingMethod() {
        return biddingMethod;
    }

    /**
     * 设置招标方式:(selectedmysupplier：邀请招标 / open：公开招标)     *
     * 参数示例：<pre>open</pre>     
     * 此参数必填
     */
    public void setBiddingMethod(String biddingMethod) {
        this.biddingMethod = biddingMethod;
    }

    private String biddingAreaCode;

    /**
     * @return 招标地区code
     */
    public String getBiddingAreaCode() {
        return biddingAreaCode;
    }

    /**
     * 设置招标地区code     *
     * 参数示例：<pre>1098,1099,4476</pre>     
     * 此参数必填
     */
    public void setBiddingAreaCode(String biddingAreaCode) {
        this.biddingAreaCode = biddingAreaCode;
    }

    private String biddingAreaName;

    /**
     * @return 招标地区Name
     */
    public String getBiddingAreaName() {
        return biddingAreaName;
    }

    /**
     * 设置招标地区Name     *
     * 参数示例：<pre>北京-北京-北京市朝阳区</pre>     
     * 此参数必填
     */
    public void setBiddingAreaName(String biddingAreaName) {
        this.biddingAreaName = biddingAreaName;
    }

    private String biddingType;

    /**
     * @return 招标类型:(service：服务 / enginerring：工程 / material：物资)
     */
    public String getBiddingType() {
        return biddingType;
    }

    /**
     * 设置招标类型:(service：服务 / enginerring：工程 / material：物资)     *
     * 参数示例：<pre>enginerring</pre>     
     * 此参数必填
     */
    public void setBiddingType(String biddingType) {
        this.biddingType = biddingType;
    }

    private String purchaseBudget;

    /**
     * @return 采购预算（整数型）
     */
    public String getPurchaseBudget() {
        return purchaseBudget;
    }

    /**
     * 设置采购预算（整数型）     *
     * 参数示例：<pre>100</pre>     
     * 此参数必填
     */
    public void setPurchaseBudget(String purchaseBudget) {
        this.purchaseBudget = purchaseBudget;
    }

    private String subBizType;

    /**
     * @return 采购类型:(singlepurchase：单次购买 / priceprotocol：协议采购)
     */
    public String getSubBizType() {
        return subBizType;
    }

    /**
     * 设置采购类型:(singlepurchase：单次购买 / priceprotocol：协议采购)     *
     * 参数示例：<pre>singlepurchase</pre>     
     * 此参数必填
     */
    public void setSubBizType(String subBizType) {
        this.subBizType = subBizType;
    }

    private String receiveBeginDate;

    /**
     * @return 期望收货日期开始
     */
    public String getReceiveBeginDate() {
        return receiveBeginDate;
    }

    /**
     * 设置期望收货日期开始     *
     * 参数示例：<pre>2021-05-08</pre>     
     * 此参数必填
     */
    public void setReceiveBeginDate(String receiveBeginDate) {
        this.receiveBeginDate = receiveBeginDate;
    }

    private String receiveEndDate;

    /**
     * @return 期望收货日期截止
     */
    public String getReceiveEndDate() {
        return receiveEndDate;
    }

    /**
     * 设置期望收货日期截止     *
     * 参数示例：<pre>2021-05-14</pre>     
     * 此参数必填
     */
    public void setReceiveEndDate(String receiveEndDate) {
        this.receiveEndDate = receiveEndDate;
    }

    private String receiveAddressCode;

    /**
     * @return 收货地址code
     */
    public String getReceiveAddressCode() {
        return receiveAddressCode;
    }

    /**
     * 设置收货地址code     *
     * 参数示例：<pre>1098,1099,4488,新街口街道asdf</pre>     
     * 此参数必填
     */
    public void setReceiveAddressCode(String receiveAddressCode) {
        this.receiveAddressCode = receiveAddressCode;
    }

    private String receiveDisplayAddress;

    /**
     * @return 收货地址展示
     */
    public String getReceiveDisplayAddress() {
        return receiveDisplayAddress;
    }

    /**
     * 设置收货地址展示     *
     * 参数示例：<pre>北京-北京市-西城区-新街口街道</pre>     
     * 此参数必填
     */
    public void setReceiveDisplayAddress(String receiveDisplayAddress) {
        this.receiveDisplayAddress = receiveDisplayAddress;
    }

    private String temporaryAddressCode;

    /**
     * @return 临时收货地址code
     */
    public String getTemporaryAddressCode() {
        return temporaryAddressCode;
    }

    /**
     * 设置临时收货地址code     *
     * 参数示例：<pre>3478,3486,3487,鄞州区</pre>     
     * 此参数必填
     */
    public void setTemporaryAddressCode(String temporaryAddressCode) {
        this.temporaryAddressCode = temporaryAddressCode;
    }

    private String temporaryDisplayAddress;

    /**
     * @return 临时收货地址展示字段
     */
    public String getTemporaryDisplayAddress() {
        return temporaryDisplayAddress;
    }

    /**
     * 设置临时收货地址展示字段     *
     * 参数示例：<pre>浙江-宁波-宁波市-鄞州区</pre>     
     * 此参数必填
     */
    public void setTemporaryDisplayAddress(String temporaryDisplayAddress) {
        this.temporaryDisplayAddress = temporaryDisplayAddress;
    }

    private Boolean useTempAsReceive;

    /**
     * @return 是否使用临时地址作为收货地址（true/false）不传默认false
     */
    public Boolean getUseTempAsReceive() {
        return useTempAsReceive;
    }

    /**
     * 设置是否使用临时地址作为收货地址（true/false）不传默认false     *
     * 参数示例：<pre>false</pre>     
     * 此参数必填
     */
    public void setUseTempAsReceive(Boolean useTempAsReceive) {
        this.useTempAsReceive = useTempAsReceive;
    }

    private String biddingOrgName;

    /**
     * @return 招标单位的名称
     */
    public String getBiddingOrgName() {
        return biddingOrgName;
    }

    /**
     * 设置招标单位的名称     *
     * 参数示例：<pre>123-123rr</pre>     
     * 此参数必填
     */
    public void setBiddingOrgName(String biddingOrgName) {
        this.biddingOrgName = biddingOrgName;
    }

    private String biddingOrgCode;

    /**
     * @return 招标单位的code
     */
    public String getBiddingOrgCode() {
        return biddingOrgCode;
    }

    /**
     * 设置招标单位的code     *
     * 参数示例：<pre>123-123</pre>     
     * 此参数必填
     */
    public void setBiddingOrgCode(String biddingOrgCode) {
        this.biddingOrgCode = biddingOrgCode;
    }

    private String biddingPlanCode;

    /**
     * @return 招标计划code:(year：年度  month：月度  quarter：季度  other：其他)
     */
    public String getBiddingPlanCode() {
        return biddingPlanCode;
    }

    /**
     * 设置招标计划code:(year：年度  month：月度  quarter：季度  other：其他)     *
     * 参数示例：<pre>month</pre>     
     * 此参数必填
     */
    public void setBiddingPlanCode(String biddingPlanCode) {
        this.biddingPlanCode = biddingPlanCode;
    }

    private String biddingPlanDesc;

    /**
     * @return 招标计划描述
     */
    public String getBiddingPlanDesc() {
        return biddingPlanDesc;
    }

    /**
     * 设置招标计划描述     *
     * 参数示例：<pre>招标描述</pre>     
     * 此参数必填
     */
    public void setBiddingPlanDesc(String biddingPlanDesc) {
        this.biddingPlanDesc = biddingPlanDesc;
    }

    private String sectionList;

    /**
     * @return 招标产品 (subject：物料名称  modelNumber：型号  productFeature：物料描述  category：所属行业id) 注意：所属行业是用户配置好的1688大市场类目信息
     */
    public String getSectionList() {
        return sectionList;
    }

    /**
     * 设置招标产品 (subject：物料名称  modelNumber：型号  productFeature：物料描述  category：所属行业id) 注意：所属行业是用户配置好的1688大市场类目信息     *
     * 参数示例：<pre>[{"index":1,"name":"标段一","purchaseItemWriteParamStr":[{"productId":3661420,"purchaseNoteItemId":"","subject":"你好小z啊1244","productCode":"你好小z啊1244","purchaseAmount":"10","basePrice":"10","category":"67,10336,127822004","fullPathName":"办公、文化 > 纸品本册 > 便利贴","unit":"个","brandName":"淘宝品牌","modelNumber":"x001","productFeature":"含有多种款式","attachments":null,"prItemId":"","quoteUnit":"","userCategoryIds":"328695,328696,328697","userFullPathName":"11 > 22 > 33","attributes":"品牌：淘宝品牌；型号：x001；材质：搪胶；"}]}]</pre>     
     * 此参数必填
     */
    public void setSectionList(String sectionList) {
        this.sectionList = sectionList;
    }

    private long[] biddingAttachmentStr;

    /**
     * @return 招标文件id
     */
    public long[] getBiddingAttachmentStr() {
        return biddingAttachmentStr;
    }

    /**
     * 设置招标文件id     *
     * 参数示例：<pre>[373,8232,1323]</pre>     
     * 此参数必填
     */
    public void setBiddingAttachmentStr(long[] biddingAttachmentStr) {
        this.biddingAttachmentStr = biddingAttachmentStr;
    }

    private long[] techAttachmentStr;

    /**
     * @return 技术标文件Id
     */
    public long[] getTechAttachmentStr() {
        return techAttachmentStr;
    }

    /**
     * 设置技术标文件Id     *
     * 参数示例：<pre>[373,8232,1323]</pre>     
     * 此参数必填
     */
    public void setTechAttachmentStr(long[] techAttachmentStr) {
        this.techAttachmentStr = techAttachmentStr;
    }

    private long[] bizAttachmentStr;

    /**
     * @return 商务标文件Id
     */
    public long[] getBizAttachmentStr() {
        return bizAttachmentStr;
    }

    /**
     * 设置商务标文件Id     *
     * 参数示例：<pre>[373,8232,1323]</pre>     
     * 此参数必填
     */
    public void setBizAttachmentStr(long[] bizAttachmentStr) {
        this.bizAttachmentStr = bizAttachmentStr;
    }

    private long[] evaluateAttachmentStr;

    /**
     * @return 评标标准文件Id
     */
    public long[] getEvaluateAttachmentStr() {
        return evaluateAttachmentStr;
    }

    /**
     * 设置评标标准文件Id     *
     * 参数示例：<pre>[373,8232,1323]</pre>     
     * 此参数必填
     */
    public void setEvaluateAttachmentStr(long[] evaluateAttachmentStr) {
        this.evaluateAttachmentStr = evaluateAttachmentStr;
    }

    private String openBiddingMethod;

    /**
     * @return 开标方式，目前仅支持一次开标:one
     */
    public String getOpenBiddingMethod() {
        return openBiddingMethod;
    }

    /**
     * 设置开标方式，目前仅支持一次开标:one     *
     * 参数示例：<pre>one</pre>     
     * 此参数必填
     */
    public void setOpenBiddingMethod(String openBiddingMethod) {
        this.openBiddingMethod = openBiddingMethod;
    }

    private String gmtApplyStart;

    /**
     * @return 报名开始时间
     */
    public String getGmtApplyStart() {
        return gmtApplyStart;
    }

    /**
     * 设置报名开始时间     *
     * 参数示例：<pre>2021-05-08 00:00:00</pre>     
     * 此参数必填
     */
    public void setGmtApplyStart(String gmtApplyStart) {
        this.gmtApplyStart = gmtApplyStart;
    }

    private String gmtApplyExpire;

    /**
     * @return 报名终止时间
     */
    public String getGmtApplyExpire() {
        return gmtApplyExpire;
    }

    /**
     * 设置报名终止时间     *
     * 参数示例：<pre>2021-05-09 00:00:00</pre>     
     * 此参数必填
     */
    public void setGmtApplyExpire(String gmtApplyExpire) {
        this.gmtApplyExpire = gmtApplyExpire;
    }

    private String gmtQuotationStart;

    /**
     * @return 投标开始时间（见示例，开始与结束时间。投标开始时间大于报名结束时间）
     */
    public String getGmtQuotationStart() {
        return gmtQuotationStart;
    }

    /**
     * 设置投标开始时间（见示例，开始与结束时间。投标开始时间大于报名结束时间）     *
     * 参数示例：<pre>2021-05-10 00:00:00</pre>     
     * 此参数必填
     */
    public void setGmtQuotationStart(String gmtQuotationStart) {
        this.gmtQuotationStart = gmtQuotationStart;
    }

    private String gmtQuotationExpire;

    /**
     * @return 投标截止时间
     */
    public String getGmtQuotationExpire() {
        return gmtQuotationExpire;
    }

    /**
     * 设置投标截止时间     *
     * 参数示例：<pre>2021-05-11 00:00:00</pre>     
     * 此参数必填
     */
    public void setGmtQuotationExpire(String gmtQuotationExpire) {
        this.gmtQuotationExpire = gmtQuotationExpire;
    }

    private String gmtOpenStart;

    /**
     * @return 开标开始时间（见示例，开始与结束时间。开标开始时间大于投标结束时间）
     */
    public String getGmtOpenStart() {
        return gmtOpenStart;
    }

    /**
     * 设置开标开始时间（见示例，开始与结束时间。开标开始时间大于投标结束时间）     *
     * 参数示例：<pre>2021-05-12 00:00:00</pre>     
     * 此参数必填
     */
    public void setGmtOpenStart(String gmtOpenStart) {
        this.gmtOpenStart = gmtOpenStart;
    }

    private String gmtOpenEnd;

    /**
     * @return 开标截止时间
     */
    public String getGmtOpenEnd() {
        return gmtOpenEnd;
    }

    /**
     * 设置开标截止时间     *
     * 参数示例：<pre>2021-05-13 00:00:00</pre>     
     * 此参数必填
     */
    public void setGmtOpenEnd(String gmtOpenEnd) {
        this.gmtOpenEnd = gmtOpenEnd;
    }

    private String gmtEvaluateStart;

    /**
     * @return 评标开始时间（见示例，开始与结束时间。评标开始时间大于开标结束时间）
     */
    public String getGmtEvaluateStart() {
        return gmtEvaluateStart;
    }

    /**
     * 设置评标开始时间（见示例，开始与结束时间。评标开始时间大于开标结束时间）     *
     * 参数示例：<pre>2021-05-15 00:00:00</pre>     
     * 此参数必填
     */
    public void setGmtEvaluateStart(String gmtEvaluateStart) {
        this.gmtEvaluateStart = gmtEvaluateStart;
    }

    private String gmtEvaluateEnd;

    /**
     * @return 评标截止时间
     */
    public String getGmtEvaluateEnd() {
        return gmtEvaluateEnd;
    }

    /**
     * 设置评标截止时间     *
     * 参数示例：<pre>2021-05-16 00:00:00</pre>     
     * 此参数必填
     */
    public void setGmtEvaluateEnd(String gmtEvaluateEnd) {
        this.gmtEvaluateEnd = gmtEvaluateEnd;
    }

    private Boolean includeTax;

    /**
     * @return 报价是否含税:(true/false)
     */
    public Boolean getIncludeTax() {
        return includeTax;
    }

    /**
     * 设置报价是否含税:(true/false)     *
     * 参数示例：<pre>false</pre>     
     * 此参数必填
     */
    public void setIncludeTax(Boolean includeTax) {
        this.includeTax = includeTax;
    }

    private Boolean quoteHasPostFee;

    /**
     * @return 报价是否需要包含运费:(true/false)
     */
    public Boolean getQuoteHasPostFee() {
        return quoteHasPostFee;
    }

    /**
     * 设置报价是否需要包含运费:(true/false)     *
     * 参数示例：<pre>false</pre>     
     * 此参数必填
     */
    public void setQuoteHasPostFee(Boolean quoteHasPostFee) {
        this.quoteHasPostFee = quoteHasPostFee;
    }

    private Boolean allowPartOffer;

    /**
     * @return 是否允许对询价单商品部分报价:(true/false)
     */
    public Boolean getAllowPartOffer() {
        return allowPartOffer;
    }

    /**
     * 设置是否允许对询价单商品部分报价:(true/false)     *
     * 参数示例：<pre>false</pre>     
     * 此参数必填
     */
    public void setAllowPartOffer(Boolean allowPartOffer) {
        this.allowPartOffer = allowPartOffer;
    }

    private Boolean supplierCanModifyQuantity;

    /**
     * @return 供应商报价是否可改数量:(true/false)
     */
    public Boolean getSupplierCanModifyQuantity() {
        return supplierCanModifyQuantity;
    }

    /**
     * 设置供应商报价是否可改数量:(true/false)     *
     * 参数示例：<pre>false</pre>     
     * 此参数必填
     */
    public void setSupplierCanModifyQuantity(Boolean supplierCanModifyQuantity) {
        this.supplierCanModifyQuantity = supplierCanModifyQuantity;
    }

    private String tradeMode;

    /**
     * @return 交易方式:(见示列)，可根据页面调试传参。例子1：选账期支付，指定每月5号还款:{"alipay":false,"payperiod":true,"payperiodType":"specify","payperiodDays":"5","steppay":false,"steppayType":"stepTrade91BusinessBuy","steppayDays":"90","other":false,"otherDesc":""} 例子2:账期，不指定。收货后30天内结算 {"alipay":false,"payperiod":true,"payperiodType":"notspecify","payperiodDays":"30","steppay":false,"steppayType":"stepTrade91BusinessBuy","steppayDays":"90","other":false,"otherDesc":""} 例子3:分阶段支付，91分阶段，质保周期180天 {"alipay":false,"payperiod":false,"payperiodType":"notspecify","payperiodDays":"60","steppay":true,"steppayType":"stepTrade91BusinessBuy","steppayDays":"180","other":false,"otherDesc":""}
     */
    public String getTradeMode() {
        return tradeMode;
    }

    /**
     * 设置交易方式:(见示列)，可根据页面调试传参。例子1：选账期支付，指定每月5号还款:{"alipay":false,"payperiod":true,"payperiodType":"specify","payperiodDays":"5","steppay":false,"steppayType":"stepTrade91BusinessBuy","steppayDays":"90","other":false,"otherDesc":""} 例子2:账期，不指定。收货后30天内结算 {"alipay":false,"payperiod":true,"payperiodType":"notspecify","payperiodDays":"30","steppay":false,"steppayType":"stepTrade91BusinessBuy","steppayDays":"90","other":false,"otherDesc":""} 例子3:分阶段支付，91分阶段，质保周期180天 {"alipay":false,"payperiod":false,"payperiodType":"notspecify","payperiodDays":"60","steppay":true,"steppayType":"stepTrade91BusinessBuy","steppayDays":"180","other":false,"otherDesc":""}     *
     * 参数示例：<pre>{"alipay":false,"payperiod":false,"payperiodType":"notspecify","payperiodDays":"60","steppay":true,"steppayType":"stepTrade91BusinessBuy","steppayDays":"180","other":false,"otherDesc":""}</pre>     
     * 此参数必填
     */
    public void setTradeMode(String tradeMode) {
        this.tradeMode = tradeMode;
    }

    private String payType;

    /**
     * @return 支付方式（见示例多选，aliPay:个人支付宝 / aliPayEnterprise:企业支付宝 / bankTransfer:银行转账 / cmbInvoice:电子银行承兑汇票 / creditPeriod:付款期限）
     */
    public String getPayType() {
        return payType;
    }

    /**
     * 设置支付方式（见示例多选，aliPay:个人支付宝 / aliPayEnterprise:企业支付宝 / bankTransfer:银行转账 / cmbInvoice:电子银行承兑汇票 / creditPeriod:付款期限）     *
     * 参数示例：<pre>{"aliPay":true,"aliPayEnterprise":false,"bankTransfer":false,"cmbInvoice":false,"creditPeriod":""}</pre>     
     * 此参数必填
     */
    public void setPayType(String payType) {
        this.payType = payType;
    }

    private String invoiceType;

    /**
     * @return 发票要求:(vat：增值税专票（不限开具方) / common：增值税普通发票 / no：不需要发票 / vatSelf：增值税专票（一般纳税人开具）)
     */
    public String getInvoiceType() {
        return invoiceType;
    }

    /**
     * 设置发票要求:(vat：增值税专票（不限开具方) / common：增值税普通发票 / no：不需要发票 / vatSelf：增值税专票（一般纳税人开具）)     *
     * 参数示例：<pre>common</pre>     
     * 此参数必填
     */
    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    private Long registeredCapital;

    /**
     * @return 注册资金
     */
    public Long getRegisteredCapital() {
        return registeredCapital;
    }

    /**
     * 设置注册资金     *
     * 参数示例：<pre>1000</pre>     
     * 此参数必填
     */
    public void setRegisteredCapital(Long registeredCapital) {
        this.registeredCapital = registeredCapital;
    }

    private Boolean needSignAgreement;

    /**
     * @return 保密协议:(true/false) 需供应商签署保密协议才能查看详情、报价
     */
    public Boolean getNeedSignAgreement() {
        return needSignAgreement;
    }

    /**
     * 设置保密协议:(true/false) 需供应商签署保密协议才能查看详情、报价     *
     * 参数示例：<pre>false</pre>     
     * 此参数必填
     */
    public void setNeedSignAgreement(Boolean needSignAgreement) {
        this.needSignAgreement = needSignAgreement;
    }

    private String[] businessModels;

    /**
     * @return 经营模式（见示例多选，other:其他 / wholesale:经销批发 / trade:商业服务 / investment:招商代理 / manufacturer:生产加工）
     */
    public String[] getBusinessModels() {
        return businessModels;
    }

    /**
     * 设置经营模式（见示例多选，other:其他 / wholesale:经销批发 / trade:商业服务 / investment:招商代理 / manufacturer:生产加工）     *
     * 参数示例：<pre>["wholesale","trade","other","manufacturer","investment"]</pre>     
     * 此参数必填
     */
    public void setBusinessModels(String[] businessModels) {
        this.businessModels = businessModels;
    }

    private String[] certificateIds;

    /**
     * @return 证照要求：1688通用的证书清单，见示例多选证书id（542:(三/五证合一) / 1:营业执照 / 2:税务登记证 / 3:组织机构代码证 / 548:统计登记证 / 549:社会保险登记证）
     */
    public String[] getCertificateIds() {
        return certificateIds;
    }

    /**
     * 设置证照要求：1688通用的证书清单，见示例多选证书id（542:(三/五证合一) / 1:营业执照 / 2:税务登记证 / 3:组织机构代码证 / 548:统计登记证 / 549:社会保险登记证）     *
     * 参数示例：<pre>["1","2","3","548","549","542"]</pre>     
     * 此参数必填
     */
    public void setCertificateIds(String[] certificateIds) {
        this.certificateIds = certificateIds;
    }

    private String biddingAnnounce;

    /**
     * @return 招标公告
     */
    public String getBiddingAnnounce() {
        return biddingAnnounce;
    }

    /**
     * 设置招标公告     *
     * 参数示例：<pre><p>hhh</p></pre>     
     * 此参数必填
     */
    public void setBiddingAnnounce(String biddingAnnounce) {
        this.biddingAnnounce = biddingAnnounce;
    }

    private long[] addedAttachmentStr;

    /**
     * @return 对商家可见公告附件id
     */
    public long[] getAddedAttachmentStr() {
        return addedAttachmentStr;
    }

    /**
     * 设置对商家可见公告附件id     *
     * 参数示例：<pre>[213,422,098]</pre>     
     * 此参数必填
     */
    public void setAddedAttachmentStr(long[] addedAttachmentStr) {
        this.addedAttachmentStr = addedAttachmentStr;
    }

    private long[] internalAttachmentStr;

    /**
     * @return 对内控审批补充附件id
     */
    public long[] getInternalAttachmentStr() {
        return internalAttachmentStr;
    }

    /**
     * 设置对内控审批补充附件id     *
     * 参数示例：<pre>[213,422,098]</pre>     
     * 此参数必填
     */
    public void setInternalAttachmentStr(long[] internalAttachmentStr) {
        this.internalAttachmentStr = internalAttachmentStr;
    }

    private String publishChannel;

    /**
     * @return 发布渠道(招标方式为公开招标，则默认发布到1688) 目前仅支持：1688portal
     */
    public String getPublishChannel() {
        return publishChannel;
    }

    /**
     * 设置发布渠道(招标方式为公开招标，则默认发布到1688) 目前仅支持：1688portal     *
     * 参数示例：<pre>1688portal</pre>     
     * 此参数必填
     */
    public void setPublishChannel(String publishChannel) {
        this.publishChannel = publishChannel;
    }

    private String entrySource;

    /**
     * @return 来源，目前仅支持：outside
     */
    public String getEntrySource() {
        return entrySource;
    }

    /**
     * 设置来源，目前仅支持：outside     *
     * 参数示例：<pre>outside</pre>     
     * 此参数必填
     */
    public void setEntrySource(String entrySource) {
        this.entrySource = entrySource;
    }

    private Boolean publishChange;

    /**
     * @return 是否发布变更:(true/false)，首次创建填false,之后修改填true
     */
    public Boolean getPublishChange() {
        return publishChange;
    }

    /**
     * 设置是否发布变更:(true/false)，首次创建填false,之后修改填true     *
     * 参数示例：<pre>false</pre>     
     * 此参数必填
     */
    public void setPublishChange(Boolean publishChange) {
        this.publishChange = publishChange;
    }

    private String inviteSupplierMemberIds;

    /**
     * @return 如果是定向邀请该参数必填（传的是供应商memberId如果多个供应商用英文,分隔）
     */
    public String getInviteSupplierMemberIds() {
        return inviteSupplierMemberIds;
    }

    /**
     * 设置如果是定向邀请该参数必填（传的是供应商memberId如果多个供应商用英文,分隔）     *
     * 参数示例：<pre>b2b-2248544119,b2b-2249544159</pre>     
     * 此参数必填
     */
    public void setInviteSupplierMemberIds(String inviteSupplierMemberIds) {
        this.inviteSupplierMemberIds = inviteSupplierMemberIds;
    }

    private Boolean modify;

    /**
     * @return 是否修改:(true/false),首次创建填false
     */
    public Boolean getModify() {
        return modify;
    }

    /**
     * 设置是否修改:(true/false),首次创建填false     *
     * 参数示例：<pre>false</pre>     
     * 此参数必填
     */
    public void setModify(Boolean modify) {
        this.modify = modify;
    }

    private String protocolBeginDate;

    /**
     * @return 价格有效期开始:（见示例，开始与结束时间。注意：若采购类型为协议采购，此参数必传）
     */
    public String getProtocolBeginDate() {
        return protocolBeginDate;
    }

    /**
     * 设置价格有效期开始:（见示例，开始与结束时间。注意：若采购类型为协议采购，此参数必传）     *
     * 参数示例：<pre>2021-05-14</pre>     
     * 此参数必填
     */
    public void setProtocolBeginDate(String protocolBeginDate) {
        this.protocolBeginDate = protocolBeginDate;
    }

    private String protocolEndDate;

    /**
     * @return 价格有效期结束:（见示例，开始与结束时间。注意：若采购类型为协议采购，此参数必传）
     */
    public String getProtocolEndDate() {
        return protocolEndDate;
    }

    /**
     * 设置价格有效期结束:（见示例，开始与结束时间。注意：若采购类型为协议采购，此参数必传）     *
     * 参数示例：<pre>2021-06-14</pre>     
     * 此参数必填
     */
    public void setProtocolEndDate(String protocolEndDate) {
        this.protocolEndDate = protocolEndDate;
    }

    private Long buyerUserId;

    /**
     * @return 用户userId:(主账号userId或者子账号userId)
     */
    public Long getBuyerUserId() {
        return buyerUserId;
    }

    /**
     * 设置用户userId:(主账号userId或者子账号userId)     *
     * 参数示例：<pre>87782328</pre>     
     * 此参数必填
     */
    public void setBuyerUserId(Long buyerUserId) {
        this.buyerUserId = buyerUserId;
    }

    private Boolean acceptConsortiumBids;

    /**
     * @return 是否接收联合体投标 （true代表接收）
     */
    public Boolean getAcceptConsortiumBids() {
        return acceptConsortiumBids;
    }

    /**
     * 设置是否接收联合体投标 （true代表接收）     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setAcceptConsortiumBids(Boolean acceptConsortiumBids) {
        this.acceptConsortiumBids = acceptConsortiumBids;
    }

    private String industryCategoryCode;

    /**
     * @return 项目行业分类编码
     */
    public String getIndustryCategoryCode() {
        return industryCategoryCode;
    }

    /**
     * 设置项目行业分类编码     *
     * 参数示例：<pre>G11</pre>     
     * 此参数必填
     */
    public void setIndustryCategoryCode(String industryCategoryCode) {
        this.industryCategoryCode = industryCategoryCode;
    }

    private String biddingContact;

    /**
     * @return 招标联系人
     */
    public String getBiddingContact() {
        return biddingContact;
    }

    /**
     * 设置招标联系人     *
     * 参数示例：<pre>李四</pre>     
     * 此参数必填
     */
    public void setBiddingContact(String biddingContact) {
        this.biddingContact = biddingContact;
    }

    private String biddingContactPhone;

    /**
     * @return 招标联系人电话
     */
    public String getBiddingContactPhone() {
        return biddingContactPhone;
    }

    /**
     * 设置招标联系人电话     *
     * 参数示例：<pre>1358572391</pre>     
     * 此参数必填
     */
    public void setBiddingContactPhone(String biddingContactPhone) {
        this.biddingContactPhone = biddingContactPhone;
    }

    private String biddingContactEmail;

    /**
     * @return 招标联系人邮箱
     */
    public String getBiddingContactEmail() {
        return biddingContactEmail;
    }

    /**
     * 设置招标联系人邮箱     *
     * 参数示例：<pre>1358572391@163.com</pre>     
     * 此参数必填
     */
    public void setBiddingContactEmail(String biddingContactEmail) {
        this.biddingContactEmail = biddingContactEmail;
    }

    private String guaranteeAmountStr;

    /**
     * @return 保证金
     */
    public String getGuaranteeAmountStr() {
        return guaranteeAmountStr;
    }

    /**
     * 设置保证金     *
     * 参数示例：<pre>10000</pre>     
     * 此参数必填
     */
    public void setGuaranteeAmountStr(String guaranteeAmountStr) {
        this.guaranteeAmountStr = guaranteeAmountStr;
    }

    private String guaranteeAccounts;

    /**
     * @return 保证金账户多个用","分割
     */
    public String getGuaranteeAccounts() {
        return guaranteeAccounts;
    }

    /**
     * 设置保证金账户多个用","分割     *
     * 参数示例：<pre>账户1</pre>     
     * 此参数必填
     */
    public void setGuaranteeAccounts(String guaranteeAccounts) {
        this.guaranteeAccounts = guaranteeAccounts;
    }

    private Boolean guarantee;

    /**
     * @return 是否收取保证金(true/false)
     */
    public Boolean getGuarantee() {
        return guarantee;
    }

    /**
     * 设置是否收取保证金(true/false)     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setGuarantee(Boolean guarantee) {
        this.guarantee = guarantee;
    }

    private long[] bidCommitmentAttachmentStr;

    /**
     * @return 投标承诺书附件id
     */
    public long[] getBidCommitmentAttachmentStr() {
        return bidCommitmentAttachmentStr;
    }

    /**
     * 设置投标承诺书附件id     *
     * 参数示例：<pre>[373,8232,1323]</pre>     
     * 此参数必填
     */
    public void setBidCommitmentAttachmentStr(long[] bidCommitmentAttachmentStr) {
        this.bidCommitmentAttachmentStr = bidCommitmentAttachmentStr;
    }

    private Boolean needBidCommitment;

    /**
     * @return 供应商是否必须盖章上传投标承诺书相关附件
     */
    public Boolean getNeedBidCommitment() {
        return needBidCommitment;
    }

    /**
     * 设置供应商是否必须盖章上传投标承诺书相关附件     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setNeedBidCommitment(Boolean needBidCommitment) {
        this.needBidCommitment = needBidCommitment;
    }

}
