package cn.alibaba.open.param;

import java.util.*;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AlibabaCaigouCoopapiContractParamCoopCreateContractParam {

    private AlibabaCaigouCoopapiContractParamCoopContractAttachmentParam[] attachmentParams;

    /**
     * @return 附件
     */
    public AlibabaCaigouCoopapiContractParamCoopContractAttachmentParam[] getAttachmentParams() {
        return attachmentParams;
    }

    /**
     * 设置附件     *
     * 参数示例：<pre>合同正文附件1.pdf</pre>     
     * 此参数必填
     */
    public void setAttachmentParams(AlibabaCaigouCoopapiContractParamCoopContractAttachmentParam[] attachmentParams) {
        this.attachmentParams = attachmentParams;
    }

    private String beginDate;

    /**
     * @return 开始日期
     */
    public String getBeginDate() {
        return beginDate;
    }

    /**
     * 设置开始日期     *
     * 参数示例：<pre>20201123173719000+0800</pre>     
     * 此参数必填
     */
    public void setBeginDate(String beginDate) {
        this.beginDate = beginDate;
    }

    private String buyerGroupCode;

    /**
     * @return 采购组织
     */
    public String getBuyerGroupCode() {
        return buyerGroupCode;
    }

    /**
     * 设置采购组织     *
     * 参数示例：<pre>采购组1</pre>     
     * 此参数必填
     */
    public void setBuyerGroupCode(String buyerGroupCode) {
        this.buyerGroupCode = buyerGroupCode;
    }

    private Long buyerUserId;

    /**
     * @return 买家userId
     */
    public Long getBuyerUserId() {
        return buyerUserId;
    }

    /**
     * 设置买家userId     *
     * 参数示例：<pre>220983771</pre>     
     * 此参数必填
     */
    public void setBuyerUserId(Long buyerUserId) {
        this.buyerUserId = buyerUserId;
    }

    private String companyCode;

    /**
     * @return 公司编码
     */
    public String getCompanyCode() {
        return companyCode;
    }

    /**
     * 设置公司编码     *
     * 参数示例：<pre>1</pre>     
     * 此参数必填
     */
    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    private AlibabaCaigouCoopapiContractParamCoopContractAttachmentParam contractAttachmentParam;

    /**
     * @return 合同正文附件(必须是pdf、doc、docx格式,最大为100M)
     */
    public AlibabaCaigouCoopapiContractParamCoopContractAttachmentParam getContractAttachmentParam() {
        return contractAttachmentParam;
    }

    /**
     * 设置合同正文附件(必须是pdf、doc、docx格式,最大为100M)     *
     * 参数示例：<pre>合同正文附件1.pdf</pre>     
     * 此参数必填
     */
    public void setContractAttachmentParam(AlibabaCaigouCoopapiContractParamCoopContractAttachmentParam contractAttachmentParam) {
        this.contractAttachmentParam = contractAttachmentParam;
    }

    private String contractCode;

    /**
     * @return 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 设置合同编号     *
     * 参数示例：<pre>229852179</pre>     
     * 此参数必填
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    private AlibabaCaigouCoopapiContractParamCoopContractAttachmentParam[] contractOtherAttachmentParams;

    /**
     * @return 合同其他附件(必须是pdf、doc、docx格式,最多只能传10个文件,单个文件最多100M)
     */
    public AlibabaCaigouCoopapiContractParamCoopContractAttachmentParam[] getContractOtherAttachmentParams() {
        return contractOtherAttachmentParams;
    }

    /**
     * 设置合同其他附件(必须是pdf、doc、docx格式,最多只能传10个文件,单个文件最多100M)     *
     * 参数示例：<pre>合同其他附件2.doc</pre>     
     * 此参数必填
     */
    public void setContractOtherAttachmentParams(AlibabaCaigouCoopapiContractParamCoopContractAttachmentParam[] contractOtherAttachmentParams) {
        this.contractOtherAttachmentParams = contractOtherAttachmentParams;
    }

    private String createStatus;

    /**
     * @return 创建状态     （ effective:有效,draft:草稿）
     */
    public String getCreateStatus() {
        return createStatus;
    }

    /**
     * 设置创建状态     （ effective:有效,draft:草稿）     *
     * 参数示例：<pre>effective</pre>     
     * 此参数必填
     */
    public void setCreateStatus(String createStatus) {
        this.createStatus = createStatus;
    }

    private String creatorLongId;

    /**
     * @return 创建人登录阿里的账号
     */
    public String getCreatorLongId() {
        return creatorLongId;
    }

    /**
     * 设置创建人登录阿里的账号     *
     * 参数示例：<pre>b1张三</pre>     
     * 此参数必填
     */
    public void setCreatorLongId(String creatorLongId) {
        this.creatorLongId = creatorLongId;
    }

    private String[] effectedCompanyCode;

    /**
     * @return 1
     */
    public String[] getEffectedCompanyCode() {
        return effectedCompanyCode;
    }

    /**
     * 设置1     *
     * 参数示例：<pre>1</pre>     
     * 此参数必填
     */
    public void setEffectedCompanyCode(String[] effectedCompanyCode) {
        this.effectedCompanyCode = effectedCompanyCode;
    }

    private String endDate;

    /**
     * @return 结束日期
     */
    public String getEndDate() {
        return endDate;
    }

    /**
     * 设置结束日期     *
     * 参数示例：<pre>20201123173719000+0800</pre>     
     * 此参数必填
     */
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    private String invoiceType;

    /**
     * @return 发票类型(vat,common,no)
     */
    public String getInvoiceType() {
        return invoiceType;
    }

    /**
     * 设置发票类型(vat,common,no)     *
     * 参数示例：<pre>vat</pre>     
     * 此参数必填
     */
    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    private AlibabaCaigouCoopapiContractParamCoopContractItemCreateParam[] itemCreateParams;

    /**
     * @return 物料行信息
     */
    public AlibabaCaigouCoopapiContractParamCoopContractItemCreateParam[] getItemCreateParams() {
        return itemCreateParams;
    }

    /**
     * 设置物料行信息     *
     * 参数示例：<pre>见示例</pre>     
     * 此参数必填
     */
    public void setItemCreateParams(AlibabaCaigouCoopapiContractParamCoopContractItemCreateParam[] itemCreateParams) {
        this.itemCreateParams = itemCreateParams;
    }

    private String outSysNum;

    /**
     * @return 外部框架协议编号
     */
    public String getOutSysNum() {
        return outSysNum;
    }

    /**
     * 设置外部框架协议编号     *
     * 参数示例：<pre>2215697</pre>     
     * 此参数必填
     */
    public void setOutSysNum(String outSysNum) {
        this.outSysNum = outSysNum;
    }

    private String payType;

    /**
     * @return (companyalipay:企业支付宝; personalipay:企业或个人支付宝;transbybank:银行转账;mybanketicket:电子承兑汇票)
     */
    public String getPayType() {
        return payType;
    }

    /**
     * 设置(companyalipay:企业支付宝; personalipay:企业或个人支付宝;transbybank:银行转账;mybanketicket:电子承兑汇票)     *
     * 参数示例：<pre>transbybank</pre>     
     * 此参数必填
     */
    public void setPayType(String payType) {
        this.payType = payType;
    }

    private String pricingMode;

    /**
     * @return 1
     */
    public String getPricingMode() {
        return pricingMode;
    }

    /**
     * 设置1     *
     * 参数示例：<pre>1</pre>     
     * 此参数必填
     */
    public void setPricingMode(String pricingMode) {
        this.pricingMode = pricingMode;
    }

    private String purchasingOrgCode;

    /**
     * @return 1
     */
    public String getPurchasingOrgCode() {
        return purchasingOrgCode;
    }

    /**
     * 设置1     *
     * 参数示例：<pre>1</pre>     
     * 此参数必填
     */
    public void setPurchasingOrgCode(String purchasingOrgCode) {
        this.purchasingOrgCode = purchasingOrgCode;
    }

    private String remark;

    /**
     * @return 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 设置备注     *
     * 参数示例：<pre>框架协议备注信息</pre>     
     * 此参数必填
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    private AlibabaCaigouCoopapiContractParamCoopContractSignInfoParam signInfoParam;

    /**
     * @return 1
     */
    public AlibabaCaigouCoopapiContractParamCoopContractSignInfoParam getSignInfoParam() {
        return signInfoParam;
    }

    /**
     * 设置1     *
     * 参数示例：<pre>1</pre>     
     * 此参数必填
     */
    public void setSignInfoParam(AlibabaCaigouCoopapiContractParamCoopContractSignInfoParam signInfoParam) {
        this.signInfoParam = signInfoParam;
    }

    private String supplierCode;

    /**
     * @return 供应商编码
     */
    public String getSupplierCode() {
        return supplierCode;
    }

    /**
     * 设置供应商编码     *
     * 参数示例：<pre>1</pre>     
     * 此参数必填
     */
    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    private String supplierLoginId;

    /**
     * @return 供应商登录阿里的账号
     */
    public String getSupplierLoginId() {
        return supplierLoginId;
    }

    /**
     * 设置供应商登录阿里的账号     *
     * 参数示例：<pre>b1李四</pre>     
     * 此参数必填
     */
    public void setSupplierLoginId(String supplierLoginId) {
        this.supplierLoginId = supplierLoginId;
    }

    private String title;

    /**
     * @return 框架协议 标题
     */
    public String getTitle() {
        return title;
    }

    /**
     * 设置框架协议 标题     *
     * 参数示例：<pre>1</pre>     
     * 此参数必填
     */
    public void setTitle(String title) {
        this.title = title;
    }

    private String tradeType;

    /**
     * @return 交易方式   (alipay:担保交易;payperiod:账期支付;step91:91分阶段付款;step631:631分阶段付款;step361:361分阶段付款;step37:37分阶段付款;)
     */
    public String getTradeType() {
        return tradeType;
    }

    /**
     * 设置交易方式   (alipay:担保交易;payperiod:账期支付;step91:91分阶段付款;step631:631分阶段付款;step361:361分阶段付款;step37:37分阶段付款;)     *
     * 参数示例：<pre>payperiod</pre>     
     * 此参数必填
     */
    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    private String type;

    /**
     * @return 框架协议类型      ( fixed_total_price        普通价格协议;      * single_purchase_contract 单次采购合同;      longTerm_purchase_contract 长期采购合同)
     */
    public String getType() {
        return type;
    }

    /**
     * 设置框架协议类型      ( fixed_total_price        普通价格协议;      * single_purchase_contract 单次采购合同;      longTerm_purchase_contract 长期采购合同)     *
     * 参数示例：<pre>fixed_total_price</pre>     
     * 此参数必填
     */
    public void setType(String type) {
        this.type = type;
    }

}
