package cn.alibaba.open.param;

import java.util.*;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AlibabaCaigouCoopapiQuotationParamSupplierMultiQuoteParam {

    private Long buyOfferId;

    /**
     * @return 报价单ID
     */
    public Long getBuyOfferId() {
        return buyOfferId;
    }

    /**
     * 设置报价单ID     *
     * 参数示例：<pre>42380011872</pre>     
     * 此参数必填
     */
    public void setBuyOfferId(Long buyOfferId) {
        this.buyOfferId = buyOfferId;
    }

    private Boolean buyerDeleteMark;

    /**
     * @return 买家删除标记
     */
    public Boolean getBuyerDeleteMark() {
        return buyerDeleteMark;
    }

    /**
     * 设置买家删除标记     *
     * 参数示例：<pre>false</pre>     
     * 此参数必填
     */
    public void setBuyerDeleteMark(Boolean buyerDeleteMark) {
        this.buyerDeleteMark = buyerDeleteMark;
    }

    private Boolean encryptQuote;

    /**
     * @return 是否密封报价。true:密封比价；fasle:非密封比价
     */
    public Boolean getEncryptQuote() {
        return encryptQuote;
    }

    /**
     * 设置是否密封报价。true:密封比价；fasle:非密封比价     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setEncryptQuote(Boolean encryptQuote) {
        this.encryptQuote = encryptQuote;
    }

    private String endDate;

    /**
     * @return 报价截止日期(参数格式：yyyy-MM-dd HH:mm:ss)
     */
    public String getEndDate() {
        return endDate;
    }

    /**
     * 设置报价截止日期(参数格式：yyyy-MM-dd HH:mm:ss)     *
     * 参数示例：<pre>2020-11-26 00:00:00</pre>     
     * 此参数必填
     */
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    private String endTime;

    /**
     * @return 报价单结束时间(参数格式：yyyy-MM-dd HH:mm:ss)
     */
    public String getEndTime() {
        return endTime;
    }

    /**
     * 设置报价单结束时间(参数格式：yyyy-MM-dd HH:mm:ss)     *
     * 参数示例：<pre>2020-12-26 00:00:00</pre>     
     * 此参数必填
     */
    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    private String inviteSuppliers;

    /**
     * @return 供应商信息。[{"请购单ID”:"xxx","当前登录账号":""}]
     */
    public String getInviteSuppliers() {
        return inviteSuppliers;
    }

    /**
     * 设置供应商信息。[{"请购单ID”:"xxx","当前登录账号":""}]     *
     * 参数示例：<pre>[{"quotationId":1176920401198,"supplierMemberId":"b2b-2249991577"}]</pre>     
     * 此参数必填
     */
    public void setInviteSuppliers(String inviteSuppliers) {
        this.inviteSuppliers = inviteSuppliers;
    }

    private Double maxTotalPrice;

    /**
     * @return 最大总价
     */
    public Double getMaxTotalPrice() {
        return maxTotalPrice;
    }

    /**
     * 设置最大总价     *
     * 参数示例：<pre>0</pre>     
     * 此参数必填
     */
    public void setMaxTotalPrice(Double maxTotalPrice) {
        this.maxTotalPrice = maxTotalPrice;
    }

    private Double minTotalPrice;

    /**
     * @return 最小总价
     */
    public Double getMinTotalPrice() {
        return minTotalPrice;
    }

    /**
     * 设置最小总价     *
     * 参数示例：<pre>0</pre>     
     * 此参数必填
     */
    public void setMinTotalPrice(Double minTotalPrice) {
        this.minTotalPrice = minTotalPrice;
    }

    private String multiMemo;

    /**
     * @return 备注
     */
    public String getMultiMemo() {
        return multiMemo;
    }

    /**
     * 设置备注     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setMultiMemo(String multiMemo) {
        this.multiMemo = multiMemo;
    }

    private String multiReason;

    /**
     * @return 多轮报价原因。[供应商报价单已失效,供应商谈判降低采购成本,供应商报价信息有误,询报价采购流程需要,其他]
     */
    public String getMultiReason() {
        return multiReason;
    }

    /**
     * 设置多轮报价原因。[供应商报价单已失效,供应商谈判降低采购成本,供应商报价信息有误,询报价采购流程需要,其他]     *
     * 参数示例：<pre>其他</pre>     
     * 此参数必填
     */
    public void setMultiReason(String multiReason) {
        this.multiReason = multiReason;
    }

    private Integer pageNum;

    /**
     * @return 页码
     */
    public Integer getPageNum() {
        return pageNum;
    }

    /**
     * 设置页码     *
     * 参数示例：<pre>1</pre>     
     * 此参数必填
     */
    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    private Integer pageSize;

    /**
     * @return 分页大小(默认为：10)
     */
    public Integer getPageSize() {
        return pageSize;
    }

    /**
     * 设置分页大小(默认为：10)     *
     * 参数示例：<pre>10</pre>     
     * 此参数必填
     */
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    private Boolean quoteMark;

    /**
     * @return 备选标记
     */
    public Boolean getQuoteMark() {
        return quoteMark;
    }

    /**
     * 设置备选标记     *
     * 参数示例：<pre>false</pre>     
     * 此参数必填
     */
    public void setQuoteMark(Boolean quoteMark) {
        this.quoteMark = quoteMark;
    }

    private String sortBy;

    /**
     * @return 排序字段
     */
    public String getSortBy() {
        return sortBy;
    }

    /**
     * 设置排序字段     *
     * 参数示例：<pre>gmtCreate</pre>     
     * 此参数必填
     */
    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    private String sortType;

    /**
     * @return 排序类型(DESC/ASC)
     */
    public String getSortType() {
        return sortType;
    }

    /**
     * 设置排序类型(DESC/ASC)     *
     * 参数示例：<pre>DESC</pre>     
     * 此参数必填
     */
    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    private String startTime;

    /**
     * @return 报价单开始时间(参数格式：yyyy-MM-dd HH:mm:ss)
     */
    public String getStartTime() {
        return startTime;
    }

    /**
     * 设置报价单开始时间(参数格式：yyyy-MM-dd HH:mm:ss)     *
     * 参数示例：<pre>2020-11-26 00:00:00</pre>     
     * 此参数必填
     */
    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    private Long userId;

    /**
     * @return 用户ID
     */
    public Long getUserId() {
        return userId;
    }

    /**
     * 设置用户ID     *
     * 参数示例：<pre>2062093241</pre>     
     * 此参数必填
     */
    public void setUserId(Long userId) {
        this.userId = userId;
    }

}
