package cn.alibaba.open.param;

import com.alibaba.ocean.rawsdk.client.APIId;
import com.alibaba.ocean.rawsdk.common.AbstractAPIRequest;

import java.util.*;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AlibabaCaigouCreateAgreementPriceParam extends AbstractAPIRequest<AlibabaCaigouCreateAgreementPriceResult> {

    public AlibabaCaigouCreateAgreementPriceParam() {
        super();
        oceanApiId = new APIId("cn.alibaba.open", "alibaba.caigou.createAgreementPrice", 1);
    }

    private String title;

    /**
     * @return 物料名称
     */
    public String getTitle() {
        return title;
    }

    /**
     * 设置物料名称     *
     * 参数示例：<pre>物料示例</pre>     
     * 此参数必填
     */
    public void setTitle(String title) {
        this.title = title;
    }

    private String productCode;

    /**
     * @return 物料编码
     */
    public String getProductCode() {
        return productCode;
    }

    /**
     * 设置物料编码     *
     * 参数示例：<pre>test_product</pre>     
     * 此参数必填
     */
    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    private String productDesc;

    /**
     * @return 补充说明
     */
    public String getProductDesc() {
        return productDesc;
    }

    /**
     * 设置补充说明     *
     * 参数示例：<pre>品牌：3m</pre>     
     * 此参数必填
     */
    public void setProductDesc(String productDesc) {
        this.productDesc = productDesc;
    }

    private String supplierLoginId;

    /**
     * @return 供应商登陆ID
     */
    public String getSupplierLoginId() {
        return supplierLoginId;
    }

    /**
     * 设置供应商登陆ID     *
     * 参数示例：<pre>alitpforpd</pre>     
     * 此参数必填
     */
    public void setSupplierLoginId(String supplierLoginId) {
        this.supplierLoginId = supplierLoginId;
    }

    private String supplierName;

    /**
     * @return 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 设置供应商名称     *
     * 参数示例：<pre>阿里巴巴</pre>     
     * 此参数必填
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    private String taxRate;

    /**
     * @return 税率，格式支持仅数字或百分税率，如1或者1%
     */
    public String getTaxRate() {
        return taxRate;
    }

    /**
     * 设置税率，格式支持仅数字或百分税率，如1或者1%     *
     * 参数示例：<pre>1%</pre>     
     * 此参数必填
     */
    public void setTaxRate(String taxRate) {
        this.taxRate = taxRate;
    }

    private String unit;

    /**
     * @return 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 设置计量单位     *
     * 参数示例：<pre>个</pre>     
     * 此参数必填
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }

    private String tradeType;

    /**
     * @return 交易方式，支持“担保交易”,"账期支付","即时到账","分阶段付款"等多种方式
     */
    public String getTradeType() {
        return tradeType;
    }

    /**
     * 设置交易方式，支持“担保交易”,"账期支付","即时到账","分阶段付款"等多种方式     *
     * 参数示例：<pre>账期支付</pre>     
     * 此参数必填
     */
    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    private String payType;

    /**
     * @return 支付方式，支持“支付宝”，“企业支付宝”，“银行转账”，“招行电子承兑”等多种方式，多值用英文逗号,隔开
     */
    public String getPayType() {
        return payType;
    }

    /**
     * 设置支付方式，支持“支付宝”，“企业支付宝”，“银行转账”，“招行电子承兑”等多种方式，多值用英文逗号,隔开     *
     * 参数示例：<pre>支付宝,银行转账</pre>     
     * 此参数必填
     */
    public void setPayType(String payType) {
        this.payType = payType;
    }

    private String invoiceRequire;

    /**
     * @return 发票要求，vat-增值税专用发票，common-增值税普通发票，no-不用发票
     */
    public String getInvoiceRequire() {
        return invoiceRequire;
    }

    /**
     * 设置发票要求，vat-增值税专用发票，common-增值税普通发票，no-不用发票     *
     * 参数示例：<pre>vat</pre>     
     * 此参数必填
     */
    public void setInvoiceRequire(String invoiceRequire) {
        this.invoiceRequire = invoiceRequire;
    }

    private String startDate;

    /**
     * @return 开始日期
     */
    public String getStartDate() {
        return startDate;
    }

    /**
     * 设置开始日期     *
     * 参数示例：<pre>2020-09-02 12:00:00</pre>     
     * 此参数必填
     */
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    private String endDate;

    /**
     * @return 结束日期
     */
    public String getEndDate() {
        return endDate;
    }

    /**
     * 设置结束日期     *
     * 参数示例：<pre>2029-09-02 12:00:00</pre>     
     * 此参数必填
     */
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    private Integer dueDays;

    /**
     * @return 到货期
     */
    public Integer getDueDays() {
        return dueDays;
    }

    /**
     * 设置到货期     *
     * 参数示例：<pre>3</pre>     
     * 此参数必填
     */
    public void setDueDays(Integer dueDays) {
        this.dueDays = dueDays;
    }

    private List provinceList;

    /**
     * @return 省列表
     */
    public List getProvinceList() {
        return provinceList;
    }

    /**
     * 设置省列表     *
     * 参数示例：<pre>浙江,重庆</pre>     
     * 此参数必填
     */
    public void setProvinceList(List provinceList) {
        this.provinceList = provinceList;
    }

    private AlibabaCaigouMallPriceRangeParam[] priceRangeList;

    /**
     * @return 阶梯价
     */
    public AlibabaCaigouMallPriceRangeParam[] getPriceRangeList() {
        return priceRangeList;
    }

    /**
     * 设置阶梯价     *
     * 参数示例：<pre>[{"moq":1,"moqPe":1.0,"price":1.0,"pricePe":10.0}]</pre>     
     * 此参数必填
     */
    public void setPriceRangeList(AlibabaCaigouMallPriceRangeParam[] priceRangeList) {
        this.priceRangeList = priceRangeList;
    }

    private String contractCode;

    /**
     * @return 合同编码
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 设置合同编码     *
     * 参数示例：<pre>12334456677</pre>     
     * 此参数必填
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    private String cargoNo;

    /**
     * @return 货号，填写货号后协议来源为货号
     */
    public String getCargoNo() {
        return cargoNo;
    }

    /**
     * 设置货号，填写货号后协议来源为货号     *
     * 参数示例：<pre>565757</pre>     
     * 此参数必填
     */
    public void setCargoNo(String cargoNo) {
        this.cargoNo = cargoNo;
    }

}
