package cn.alibaba.open.param;

import com.alibaba.ocean.rawsdk.client.APIId;
import com.alibaba.ocean.rawsdk.common.AbstractAPIRequest;

import java.util.*;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AlibabaCaigouProcurementOrderApproveOrderParam extends AbstractAPIRequest<AlibabaCaigouProcurementOrderApproveOrderResult> {

    public AlibabaCaigouProcurementOrderApproveOrderParam() {
        super();
        oceanApiId = new APIId("cn.alibaba.open", "alibaba.caigou.procurement.order.approveOrder", 1);
    }

    private Long procurementOrderId;

    /**
     * @return 采购订单id
     */
    public Long getProcurementOrderId() {
        return procurementOrderId;
    }

    /**
     * 设置采购订单id     *
     * 参数示例：<pre>85123123</pre>     
     * 此参数必填
     */
    public void setProcurementOrderId(Long procurementOrderId) {
        this.procurementOrderId = procurementOrderId;
    }

    private String erpId;

    /**
     * @return 外部erp系统id,如果status是approved和dismissed则必填，如果是draft则非必填
     */
    public String getErpId() {
        return erpId;
    }

    /**
     * 设置外部erp系统id,如果status是approved和dismissed则必填，如果是draft则非必填     *
     * 参数示例：<pre>12321</pre>     
     * 此参数必填
     */
    public void setErpId(String erpId) {
        this.erpId = erpId;
    }

    private String status;

    /**
     * @return 审批结果
     */
    public String getStatus() {
        return status;
    }

    /**
     * 设置审批结果     *
     * 参数示例：<pre>同意：approved 拒绝：dismissed 草稿：draft</pre>     
     * 此参数必填
     */
    public void setStatus(String status) {
        this.status = status;
    }

    private String errorMessage;

    /**
     * @return 错误信息
     */
    public String getErrorMessage() {
        return errorMessage;
    }

    /**
     * 设置错误信息     *
     * 参数示例：<pre>公司代码不存在</pre>     
     * 此参数必填
     */
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

}
