package cn.alibaba.open.param;

import java.util.*;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AlibabaProcurementApiIntegrationModelIntegrationProcurementOrderEntryModel {

    private AlibabaProcurementApiIntegrationModelIntegrationAdditionalCharge[] additionalCharges;

    /**
     * @return 附加费用
     */
    public AlibabaProcurementApiIntegrationModelIntegrationAdditionalCharge[] getAdditionalCharges() {
        return additionalCharges;
    }

    /**
     * 设置附加费用     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setAdditionalCharges(AlibabaProcurementApiIntegrationModelIntegrationAdditionalCharge[] additionalCharges) {
        this.additionalCharges = additionalCharges;
    }

    private BigDecimal amount;

    /**
     * @return 数量
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /**
     * 设置数量     *
     * 参数示例：<pre>20</pre>     
     * 此参数必填
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    private Map attributes;

    /**
     * @return 额外信息
     */
    public Map getAttributes() {
        return attributes;
    }

    /**
     * 设置额外信息     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    private String categoryName;

    /**
     * @return 类目名称
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * 设置类目名称     *
     * 参数示例：<pre>测试类目7</pre>     
     * 此参数必填
     */
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    private String confirmedGoodsQuantity;

    /**
     * @return 收货数量
     */
    public String getConfirmedGoodsQuantity() {
        return confirmedGoodsQuantity;
    }

    /**
     * 设置收货数量     *
     * 参数示例：<pre>20</pre>     
     * 此参数必填
     */
    public void setConfirmedGoodsQuantity(String confirmedGoodsQuantity) {
        this.confirmedGoodsQuantity = confirmedGoodsQuantity;
    }

    private String creatorName;

    /**
     * @return 创建者名
     */
    public String getCreatorName() {
        return creatorName;
    }

    /**
     * 设置创建者名     *
     * 参数示例：<pre>bonlinetest</pre>     
     * 此参数必填
     */
    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    private Date deliveryDate;

    /**
     * @return 交货日期
     */
    public Date getDeliveryDate() {
        return deliveryDate;
    }

    /**
     * 设置交货日期     *
     * 参数示例：<pre>1532620800000</pre>     
     * 此参数必填
     */
    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    private String departmentCode;

    /**
     * @return 部门编号
     */
    public String getDepartmentCode() {
        return departmentCode;
    }

    /**
     * 设置部门编号     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }

    private String factoryCode;

    /**
     * @return 工厂编号
     */
    public String getFactoryCode() {
        return factoryCode;
    }

    /**
     * 设置工厂编号     *
     * 参数示例：<pre>1040</pre>     
     * 此参数必填
     */
    public void setFactoryCode(String factoryCode) {
        this.factoryCode = factoryCode;
    }

    private String frameworkContractNumber;

    /**
     * @return 框架协议合同号
     */
    public String getFrameworkContractNumber() {
        return frameworkContractNumber;
    }

    /**
     * 设置框架协议合同号     *
     * 参数示例：<pre>12502</pre>     
     * 此参数必填
     */
    public void setFrameworkContractNumber(String frameworkContractNumber) {
        this.frameworkContractNumber = frameworkContractNumber;
    }

    private String frameworkContractRowId;

    /**
     * @return 框架协议合同行号
     */
    public String getFrameworkContractRowId() {
        return frameworkContractRowId;
    }

    /**
     * 设置框架协议合同行号     *
     * 参数示例：<pre>2</pre>     
     * 此参数必填
     */
    public void setFrameworkContractRowId(String frameworkContractRowId) {
        this.frameworkContractRowId = frameworkContractRowId;
    }

    private Date gmtCreate;

    /**
     * @return 创建时间
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * 设置创建时间     *
     * 参数示例：<pre>2018-06-02</pre>     
     * 此参数必填
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    private Date gmtModified;

    /**
     * @return 修改时间
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * 设置修改时间     *
     * 参数示例：<pre>2018-09-04</pre>     
     * 此参数必填
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    private Long id;

    /**
     * @return 主键id
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置主键id     *
     * 参数示例：<pre>421</pre>     
     * 此参数必填
     */
    public void setId(Long id) {
        this.id = id;
    }

    private String materialCode;

    /**
     * @return 物料编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 设置物料编码     *
     * 参数示例：<pre>80001141</pre>     
     * 此参数必填
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    private String materialName;

    /**
     * @return 物料名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 设置物料名称     *
     * 参数示例：<pre>圆珠笔</pre>     
     * 此参数必填
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    private String operatorName;

    /**
     * @return 操作人名
     */
    public String getOperatorName() {
        return operatorName;
    }

    /**
     * 设置操作人名     *
     * 参数示例：<pre>bonlinetest测试</pre>     
     * 此参数必填
     */
    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    private String orderType;

    /**
     * @return 订单类型
     */
    public String getOrderType() {
        return orderType;
    }

    /**
     * 设置订单类型     *
     * 参数示例：<pre>standard</pre>     
     * 此参数必填
     */
    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    private String pea;

    /**
     * @return 单价（未税），单位为元
     */
    public String getPea() {
        return pea;
    }

    /**
     * 设置单价（未税），单位为元     *
     * 参数示例：<pre>10</pre>     
     * 此参数必填
     */
    public void setPea(String pea) {
        this.pea = pea;
    }

    private Long procurementOrderId;

    /**
     * @return 订单id
     */
    public Long getProcurementOrderId() {
        return procurementOrderId;
    }

    /**
     * 设置订单id     *
     * 参数示例：<pre>123</pre>     
     * 此参数必填
     */
    public void setProcurementOrderId(Long procurementOrderId) {
        this.procurementOrderId = procurementOrderId;
    }

    private String purchasingApplicationNumber;

    /**
     * @return 采购申请号
     */
    public String getPurchasingApplicationNumber() {
        return purchasingApplicationNumber;
    }

    /**
     * 设置采购申请号     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setPurchasingApplicationNumber(String purchasingApplicationNumber) {
        this.purchasingApplicationNumber = purchasingApplicationNumber;
    }

    private String purchasingApplicationRowId;

    /**
     * @return 采购申请行号
     */
    public String getPurchasingApplicationRowId() {
        return purchasingApplicationRowId;
    }

    /**
     * 设置采购申请行号     *
     * 参数示例：<pre>1</pre>     
     * 此参数必填
     */
    public void setPurchasingApplicationRowId(String purchasingApplicationRowId) {
        this.purchasingApplicationRowId = purchasingApplicationRowId;
    }

    private String rowId;

    /**
     * @return 行id
     */
    public String getRowId() {
        return rowId;
    }

    /**
     * 设置行id     *
     * 参数示例：<pre>1</pre>     
     * 此参数必填
     */
    public void setRowId(String rowId) {
        this.rowId = rowId;
    }

    private String sourceId;

    /**
     * @return 来源id
     */
    public String getSourceId() {
        return sourceId;
    }

    /**
     * 设置来源id     *
     * 参数示例：<pre>30261</pre>     
     * 此参数必填
     */
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    private String sourceRootId;

    /**
     * @return 根来源id
     */
    public String getSourceRootId() {
        return sourceRootId;
    }

    /**
     * 设置根来源id     *
     * 参数示例：<pre>6301</pre>     
     * 此参数必填
     */
    public void setSourceRootId(String sourceRootId) {
        this.sourceRootId = sourceRootId;
    }

    private String sourceType;

    /**
     * @return 来源类型
     */
    public String getSourceType() {
        return sourceType;
    }

    /**
     * 设置来源类型     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    private String status;

    /**
     * @return 状态
     */
    public String getStatus() {
        return status;
    }

    /**
     * 设置状态     *
     * 参数示例：<pre>draft</pre>     
     * 此参数必填
     */
    public void setStatus(String status) {
        this.status = status;
    }

    private String storehouseCode;

    /**
     * @return 仓库编号
     */
    public String getStorehouseCode() {
        return storehouseCode;
    }

    /**
     * 设置仓库编号     *
     * 参数示例：<pre>211</pre>     
     * 此参数必填
     */
    public void setStorehouseCode(String storehouseCode) {
        this.storehouseCode = storehouseCode;
    }

    private String taxCode;

    /**
     * @return 税码编号
     */
    public String getTaxCode() {
        return taxCode;
    }

    /**
     * 设置税码编号     *
     * 参数示例：<pre>J10</pre>     
     * 此参数必填
     */
    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    private String taxRate;

    /**
     * @return 税率
     */
    public String getTaxRate() {
        return taxRate;
    }

    /**
     * 设置税率     *
     * 参数示例：<pre>10</pre>     
     * 此参数必填
     */
    public void setTaxRate(String taxRate) {
        this.taxRate = taxRate;
    }

    private String totalCost;

    /**
     * @return 总金额（含税）
     */
    public String getTotalCost() {
        return totalCost;
    }

    /**
     * 设置总金额（含税）     *
     * 参数示例：<pre>12</pre>     
     * 此参数必填
     */
    public void setTotalCost(String totalCost) {
        this.totalCost = totalCost;
    }

    private String tpea;

    /**
     * @return 金额（未税），单位为元
     */
    public String getTpea() {
        return tpea;
    }

    /**
     * 设置金额（未税），单位为元     *
     * 参数示例：<pre>10</pre>     
     * 此参数必填
     */
    public void setTpea(String tpea) {
        this.tpea = tpea;
    }

    private String unitCode;

    /**
     * @return 单位编码
     */
    public String getUnitCode() {
        return unitCode;
    }

    /**
     * 设置单位编码     *
     * 参数示例：<pre>ge</pre>     
     * 此参数必填
     */
    public void setUnitCode(String unitCode) {
        this.unitCode = unitCode;
    }

    private String unitName;

    /**
     * @return 单位名称
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 设置单位名称     *
     * 参数示例：<pre>个</pre>     
     * 此参数必填
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    private BigDecimal shortDelivery;

    /**
     * @return 允差下限
     */
    public BigDecimal getShortDelivery() {
        return shortDelivery;
    }

    /**
     * 设置允差下限     *
     * 参数示例：<pre>10</pre>     
     * 此参数必填
     */
    public void setShortDelivery(BigDecimal shortDelivery) {
        this.shortDelivery = shortDelivery;
    }

    private BigDecimal longDelivery;

    /**
     * @return 允差上限
     */
    public BigDecimal getLongDelivery() {
        return longDelivery;
    }

    /**
     * 设置允差上限     *
     * 参数示例：<pre>2</pre>     
     * 此参数必填
     */
    public void setLongDelivery(BigDecimal longDelivery) {
        this.longDelivery = longDelivery;
    }

    private Byte tolerance;

    /**
     * @return 是否允差 0 or 1
     */
    public Byte getTolerance() {
        return tolerance;
    }

    /**
     * 设置是否允差 0 or 1     *
     * 参数示例：<pre>1</pre>     
     * 此参数必填
     */
    public void setTolerance(Byte tolerance) {
        this.tolerance = tolerance;
    }

    private String rowType;

    /**
     * @return 行类型
     */
    public String getRowType() {
        return rowType;
    }

    /**
     * 设置行类型     *
     * 参数示例：<pre>货物/商品</pre>     
     * 此参数必填
     */
    public void setRowType(String rowType) {
        this.rowType = rowType;
    }

    private String sourceCreatorName;

    /**
     * @return 上游来源系统创建用户名称
     */
    public String getSourceCreatorName() {
        return sourceCreatorName;
    }

    /**
     * 设置上游来源系统创建用户名称     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setSourceCreatorName(String sourceCreatorName) {
        this.sourceCreatorName = sourceCreatorName;
    }

    private String costCenter;

    /**
     * @return 成本中心
     */
    public String getCostCenter() {
        return costCenter;
    }

    /**
     * 设置成本中心     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setCostCenter(String costCenter) {
        this.costCenter = costCenter;
    }

    private String materialDescr;

    /**
     * @return 物料描述
     */
    public String getMaterialDescr() {
        return materialDescr;
    }

    /**
     * 设置物料描述     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setMaterialDescr(String materialDescr) {
        this.materialDescr = materialDescr;
    }

    private BigDecimal precisionPea;

    /**
     * @return 多精度单价 未税(元)
     */
    public BigDecimal getPrecisionPea() {
        return precisionPea;
    }

    /**
     * 设置多精度单价 未税(元)     *
     * 参数示例：<pre>1.022</pre>     
     * 此参数必填
     */
    public void setPrecisionPea(BigDecimal precisionPea) {
        this.precisionPea = precisionPea;
    }

    private BigDecimal precisionPia;

    /**
     * @return 多精度单价 含税(元)
     */
    public BigDecimal getPrecisionPia() {
        return precisionPia;
    }

    /**
     * 设置多精度单价 含税(元)     *
     * 参数示例：<pre>1.22</pre>     
     * 此参数必填
     */
    public void setPrecisionPia(BigDecimal precisionPia) {
        this.precisionPia = precisionPia;
    }

    private Boolean present;

    /**
     * @return 是否是赠品
     */
    public Boolean getPresent() {
        return present;
    }

    /**
     * 设置是否是赠品     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setPresent(Boolean present) {
        this.present = present;
    }

    private String sendGoodsStatus;

    /**
     * @return 发货状态
     */
    public String getSendGoodsStatus() {
        return sendGoodsStatus;
    }

    /**
     * 设置发货状态     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setSendGoodsStatus(String sendGoodsStatus) {
        this.sendGoodsStatus = sendGoodsStatus;
    }

    private String receiveGoodsStatus;

    /**
     * @return 收货状态
     */
    public String getReceiveGoodsStatus() {
        return receiveGoodsStatus;
    }

    /**
     * 设置收货状态     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setReceiveGoodsStatus(String receiveGoodsStatus) {
        this.receiveGoodsStatus = receiveGoodsStatus;
    }

    private String settlementStatus;

    /**
     * @return 结算状态
     */
    public String getSettlementStatus() {
        return settlementStatus;
    }

    /**
     * 设置结算状态     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setSettlementStatus(String settlementStatus) {
        this.settlementStatus = settlementStatus;
    }

    private String brandName;

    /**
     * @return 品牌名称
     */
    public String getBrandName() {
        return brandName;
    }

    /**
     * 设置品牌名称     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    private String brandModel;

    /**
     * @return 品牌型号
     */
    public String getBrandModel() {
        return brandModel;
    }

    /**
     * 设置品牌型号     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setBrandModel(String brandModel) {
        this.brandModel = brandModel;
    }

    private String entryStatus;

    /**
     * @return 子状态
     */
    public String getEntryStatus() {
        return entryStatus;
    }

    /**
     * 设置子状态     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setEntryStatus(String entryStatus) {
        this.entryStatus = entryStatus;
    }

    private String invoiceStatus;

    /**
     * @return 发票状态
     */
    public String getInvoiceStatus() {
        return invoiceStatus;
    }

    /**
     * 设置发票状态     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setInvoiceStatus(String invoiceStatus) {
        this.invoiceStatus = invoiceStatus;
    }

    private String returnGoodsStatus;

    /**
     * @return 退货状态
     */
    public String getReturnGoodsStatus() {
        return returnGoodsStatus;
    }

    /**
     * 设置退货状态     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setReturnGoodsStatus(String returnGoodsStatus) {
        this.returnGoodsStatus = returnGoodsStatus;
    }

    private BigDecimal sentQuantity;

    /**
     * @return 已发货量
     */
    public BigDecimal getSentQuantity() {
        return sentQuantity;
    }

    /**
     * 设置已发货量     *
     * 参数示例：<pre>10</pre>     
     * 此参数必填
     */
    public void setSentQuantity(BigDecimal sentQuantity) {
        this.sentQuantity = sentQuantity;
    }

    private BigDecimal unsentQuantity;

    /**
     * @return 待发货量
     */
    public BigDecimal getUnsentQuantity() {
        return unsentQuantity;
    }

    /**
     * 设置待发货量     *
     * 参数示例：<pre>20</pre>     
     * 此参数必填
     */
    public void setUnsentQuantity(BigDecimal unsentQuantity) {
        this.unsentQuantity = unsentQuantity;
    }

    private BigDecimal receivedQuantity;

    /**
     * @return 已收货量
     */
    public BigDecimal getReceivedQuantity() {
        return receivedQuantity;
    }

    /**
     * 设置已收货量     *
     * 参数示例：<pre>10</pre>     
     * 此参数必填
     */
    public void setReceivedQuantity(BigDecimal receivedQuantity) {
        this.receivedQuantity = receivedQuantity;
    }

    private BigDecimal nonUnreceivedQuantity;

    /**
     * @return 发起收货量
     */
    public BigDecimal getNonUnreceivedQuantity() {
        return nonUnreceivedQuantity;
    }

    /**
     * 设置发起收货量     *
     * 参数示例：<pre>20</pre>     
     * 此参数必填
     */
    public void setNonUnreceivedQuantity(BigDecimal nonUnreceivedQuantity) {
        this.nonUnreceivedQuantity = nonUnreceivedQuantity;
    }

    private BigDecimal receivableQuantity;

    /**
     * @return 可收货量
     */
    public BigDecimal getReceivableQuantity() {
        return receivableQuantity;
    }

    /**
     * 设置可收货量     *
     * 参数示例：<pre>20</pre>     
     * 此参数必填
     */
    public void setReceivableQuantity(BigDecimal receivableQuantity) {
        this.receivableQuantity = receivableQuantity;
    }

    private BigDecimal returnedQuantity;

    /**
     * @return 已退货量
     */
    public BigDecimal getReturnedQuantity() {
        return returnedQuantity;
    }

    /**
     * 设置已退货量     *
     * 参数示例：<pre>30</pre>     
     * 此参数必填
     */
    public void setReturnedQuantity(BigDecimal returnedQuantity) {
        this.returnedQuantity = returnedQuantity;
    }

    private BigDecimal nonUnreturnedQuantity;

    /**
     * @return 发起退货量
     */
    public BigDecimal getNonUnreturnedQuantity() {
        return nonUnreturnedQuantity;
    }

    /**
     * 设置发起退货量     *
     * 参数示例：<pre>10</pre>     
     * 此参数必填
     */
    public void setNonUnreturnedQuantity(BigDecimal nonUnreturnedQuantity) {
        this.nonUnreturnedQuantity = nonUnreturnedQuantity;
    }

    private BigDecimal returnableQuantity;

    /**
     * @return 可退货量
     */
    public BigDecimal getReturnableQuantity() {
        return returnableQuantity;
    }

    /**
     * 设置可退货量     *
     * 参数示例：<pre>10</pre>     
     * 此参数必填
     */
    public void setReturnableQuantity(BigDecimal returnableQuantity) {
        this.returnableQuantity = returnableQuantity;
    }

    private BigDecimal settledQuantity;

    /**
     * @return 已结算量
     */
    public BigDecimal getSettledQuantity() {
        return settledQuantity;
    }

    /**
     * 设置已结算量     *
     * 参数示例：<pre>10</pre>     
     * 此参数必填
     */
    public void setSettledQuantity(BigDecimal settledQuantity) {
        this.settledQuantity = settledQuantity;
    }

    private BigDecimal nonUnsettledQuantity;

    /**
     * @return 发起结算量
     */
    public BigDecimal getNonUnsettledQuantity() {
        return nonUnsettledQuantity;
    }

    /**
     * 设置发起结算量     *
     * 参数示例：<pre>10</pre>     
     * 此参数必填
     */
    public void setNonUnsettledQuantity(BigDecimal nonUnsettledQuantity) {
        this.nonUnsettledQuantity = nonUnsettledQuantity;
    }

    private BigDecimal unreceivedQuantity;

    /**
     * @return 待收货量/在途量
     */
    public BigDecimal getUnreceivedQuantity() {
        return unreceivedQuantity;
    }

    /**
     * 设置待收货量/在途量     *
     * 参数示例：<pre>10</pre>     
     * 此参数必填
     */
    public void setUnreceivedQuantity(BigDecimal unreceivedQuantity) {
        this.unreceivedQuantity = unreceivedQuantity;
    }

    private BigDecimal netReceiveQuantity;

    /**
     * @return 净接收量
     */
    public BigDecimal getNetReceiveQuantity() {
        return netReceiveQuantity;
    }

    /**
     * 设置净接收量     *
     * 参数示例：<pre>10</pre>     
     * 此参数必填
     */
    public void setNetReceiveQuantity(BigDecimal netReceiveQuantity) {
        this.netReceiveQuantity = netReceiveQuantity;
    }

    private String priceType;

    /**
     * @return 价格类型
     */
    public String getPriceType() {
        return priceType;
    }

    /**
     * 设置价格类型     *
     * 参数示例：<pre>fixed/floated</pre>     
     * 此参数必填
     */
    public void setPriceType(String priceType) {
        this.priceType = priceType;
    }

    private AlibabaProcurementApiBasicModelExtInfoModel extInfoModel;

    /**
     * @return 拓展信息
     */
    public AlibabaProcurementApiBasicModelExtInfoModel getExtInfoModel() {
        return extInfoModel;
    }

    /**
     * 设置拓展信息     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setExtInfoModel(AlibabaProcurementApiBasicModelExtInfoModel extInfoModel) {
        this.extInfoModel = extInfoModel;
    }

    private String categoryCode;

    /**
     * @return 最后一级类目编码
     */
    public String getCategoryCode() {
        return categoryCode;
    }

    /**
     * 设置最后一级类目编码     *
     * 参数示例：<pre>ccc2</pre>     
     * 此参数必填
     */
    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    private String referrerId;

    /**
     * @return 引用者id
     */
    public String getReferrerId() {
        return referrerId;
    }

    /**
     * 设置引用者id     *
     * 参数示例：<pre>56412</pre>     
     * 此参数必填
     */
    public void setReferrerId(String referrerId) {
        this.referrerId = referrerId;
    }

    private String referrerType;

    /**
     * @return 引用者类型
     */
    public String getReferrerType() {
        return referrerType;
    }

    /**
     * 设置引用者类型     *
     * 参数示例：<pre>mall</pre>     
     * 此参数必填
     */
    public void setReferrerType(String referrerType) {
        this.referrerType = referrerType;
    }

    private String referrerRootId;

    /**
     * @return 引用方父ID
     */
    public String getReferrerRootId() {
        return referrerRootId;
    }

    /**
     * 设置引用方父ID     *
     * 参数示例：<pre>9526441</pre>     
     * 此参数必填
     */
    public void setReferrerRootId(String referrerRootId) {
        this.referrerRootId = referrerRootId;
    }

    private String sourceBizType;

    /**
     * @return 来源业务类型
     */
    public String getSourceBizType() {
        return sourceBizType;
    }

    /**
     * 设置来源业务类型     *
     * 参数示例：<pre>framework</pre>     
     * 此参数必填
     */
    public void setSourceBizType(String sourceBizType) {
        this.sourceBizType = sourceBizType;
    }

    private String cargoNo;

    /**
     * @return 货号
     */
    public String getCargoNo() {
        return cargoNo;
    }

    /**
     * 设置货号     *
     * 参数示例：<pre>12345</pre>     
     * 此参数必填
     */
    public void setCargoNo(String cargoNo) {
        this.cargoNo = cargoNo;
    }

    private String costCenterCode;

    /**
     * @return 成本中心编码
     */
    public String getCostCenterCode() {
        return costCenterCode;
    }

    /**
     * 设置成本中心编码     *
     * 参数示例：<pre>CODE</pre>     
     * 此参数必填
     */
    public void setCostCenterCode(String costCenterCode) {
        this.costCenterCode = costCenterCode;
    }

    private BigDecimal terminatedQuantity;

    /**
     * @return 终止数量
     */
    public BigDecimal getTerminatedQuantity() {
        return terminatedQuantity;
    }

    /**
     * 设置终止数量     *
     * 参数示例：<pre>23</pre>     
     * 此参数必填
     */
    public void setTerminatedQuantity(BigDecimal terminatedQuantity) {
        this.terminatedQuantity = terminatedQuantity;
    }

    private String buyerToBuyerRemark;

    /**
     * @return 买家对内附言
     */
    public String getBuyerToBuyerRemark() {
        return buyerToBuyerRemark;
    }

    /**
     * 设置买家对内附言     *
     * 参数示例：<pre>吃了吗？</pre>     
     * 此参数必填
     */
    public void setBuyerToBuyerRemark(String buyerToBuyerRemark) {
        this.buyerToBuyerRemark = buyerToBuyerRemark;
    }

    private String buyerToSupplierRemark;

    /**
     * @return 买家对卖家附言
     */
    public String getBuyerToSupplierRemark() {
        return buyerToSupplierRemark;
    }

    /**
     * 设置买家对卖家附言     *
     * 参数示例：<pre>您闺女结婚了没呀？</pre>     
     * 此参数必填
     */
    public void setBuyerToSupplierRemark(String buyerToSupplierRemark) {
        this.buyerToSupplierRemark = buyerToSupplierRemark;
    }

}
