package cn.alibaba.open.param;

import java.util.*;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AlibabaProcurementApiIntegrationModelIntegrationProcurementOrderModel {

    private AlibabaProcurementApiIntegrationModelIntegrationAdditionalCharge[] additionalCharges;

    /**
     * @return 附加费用
     */
    public AlibabaProcurementApiIntegrationModelIntegrationAdditionalCharge[] getAdditionalCharges() {
        return additionalCharges;
    }

    /**
     * 设置附加费用     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setAdditionalCharges(AlibabaProcurementApiIntegrationModelIntegrationAdditionalCharge[] additionalCharges) {
        this.additionalCharges = additionalCharges;
    }

    private String address;

    /**
     * @return 街道地址，不包括省市编码
     */
    public String getAddress() {
        return address;
    }

    /**
     * 设置街道地址，不包括省市编码     *
     * 参数示例：<pre>黑龙江省 齐齐哈尔市 铁锋区 asdasdf</pre>     
     * 此参数必填
     */
    public void setAddress(String address) {
        this.address = address;
    }

    private String addressCodeText;

    /**
     * @return 地址区域编码对应的文本（包括国家，省，城市）
     */
    public String getAddressCodeText() {
        return addressCodeText;
    }

    /**
     * 设置地址区域编码对应的文本（包括国家，省，城市）     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setAddressCodeText(String addressCodeText) {
        this.addressCodeText = addressCodeText;
    }

    private String[] attachmentAddress;

    /**
     * @return 附件地址
     */
    public String[] getAttachmentAddress() {
        return attachmentAddress;
    }

    /**
     * 设置附件地址     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setAttachmentAddress(String[] attachmentAddress) {
        this.attachmentAddress = attachmentAddress;
    }

    private Map attributes;

    /**
     * @return 额外信息
     */
    public Map getAttributes() {
        return attributes;
    }

    /**
     * 设置额外信息     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    private String buyerPurchasingGroupCode;

    /**
     * @return 采购组编号
     */
    public String getBuyerPurchasingGroupCode() {
        return buyerPurchasingGroupCode;
    }

    /**
     * 设置采购组编号     *
     * 参数示例：<pre>CG01</pre>     
     * 此参数必填
     */
    public void setBuyerPurchasingGroupCode(String buyerPurchasingGroupCode) {
        this.buyerPurchasingGroupCode = buyerPurchasingGroupCode;
    }

    private String buyerPurchasingGroupName;

    /**
     * @return 采购组名
     */
    public String getBuyerPurchasingGroupName() {
        return buyerPurchasingGroupName;
    }

    /**
     * 设置采购组名     *
     * 参数示例：<pre>张三01</pre>     
     * 此参数必填
     */
    public void setBuyerPurchasingGroupName(String buyerPurchasingGroupName) {
        this.buyerPurchasingGroupName = buyerPurchasingGroupName;
    }

    private String buyerPurchasingOrgCode;

    /**
     * @return 采购组织编号
     */
    public String getBuyerPurchasingOrgCode() {
        return buyerPurchasingOrgCode;
    }

    /**
     * 设置采购组织编号     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setBuyerPurchasingOrgCode(String buyerPurchasingOrgCode) {
        this.buyerPurchasingOrgCode = buyerPurchasingOrgCode;
    }

    private String companyCode;

    /**
     * @return 公司编号
     */
    public String getCompanyCode() {
        return companyCode;
    }

    /**
     * 设置公司编号     *
     * 参数示例：<pre>1000</pre>     
     * 此参数必填
     */
    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    private Boolean completedDelivery;

    /**
     * @return 完成收货
     */
    public Boolean getCompletedDelivery() {
        return completedDelivery;
    }

    /**
     * 设置完成收货     *
     * 参数示例：<pre>false</pre>     
     * 此参数必填
     */
    public void setCompletedDelivery(Boolean completedDelivery) {
        this.completedDelivery = completedDelivery;
    }

    private String creatorLoginId;

    /**
     * @return 创建者登录ID
     */
    public String getCreatorLoginId() {
        return creatorLoginId;
    }

    /**
     * 设置创建者登录ID     *
     * 参数示例：<pre>bonlinetest003</pre>     
     * 此参数必填
     */
    public void setCreatorLoginId(String creatorLoginId) {
        this.creatorLoginId = creatorLoginId;
    }

    private String creatorName;

    /**
     * @return 创建者名
     */
    public String getCreatorName() {
        return creatorName;
    }

    /**
     * 设置创建者名     *
     * 参数示例：<pre>bonlinetest003</pre>     
     * 此参数必填
     */
    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    private String currency;

    /**
     * @return 货币码
     */
    public String getCurrency() {
        return currency;
    }

    /**
     * 设置货币码     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    private String departmentCode;

    /**
     * @return 部门编号
     */
    public String getDepartmentCode() {
        return departmentCode;
    }

    /**
     * 设置部门编号     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }

    private Date gmtCreate;

    /**
     * @return 创建时间
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * 设置创建时间     *
     * 参数示例：<pre>2019-02-06</pre>     
     * 此参数必填
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    private Date gmtModified;

    /**
     * @return 修改时间
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * 设置修改时间     *
     * 参数示例：<pre>2019-03-06</pre>     
     * 此参数必填
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    private Long id;

    /**
     * @return 订单主键id
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置订单主键id     *
     * 参数示例：<pre>123</pre>     
     * 此参数必填
     */
    public void setId(Long id) {
        this.id = id;
    }

    private String invoiceRequirement;

    /**
     * @return 发票要求
     */
    public String getInvoiceRequirement() {
        return invoiceRequirement;
    }

    /**
     * 设置发票要求     *
     * 参数示例：<pre>no</pre>     
     * 此参数必填
     */
    public void setInvoiceRequirement(String invoiceRequirement) {
        this.invoiceRequirement = invoiceRequirement;
    }

    private String materialTpea;

    /**
     * @return 物料总价（未税），单位为元
     */
    public String getMaterialTpea() {
        return materialTpea;
    }

    /**
     * 设置物料总价（未税），单位为元     *
     * 参数示例：<pre>12.00</pre>     
     * 此参数必填
     */
    public void setMaterialTpea(String materialTpea) {
        this.materialTpea = materialTpea;
    }

    private String mobilePhone;

    /**
     * @return 手机号	
     */
    public String getMobilePhone() {
        return mobilePhone;
    }

    /**
     * 设置手机号	     *
     * 参数示例：<pre>1240000</pre>     
     * 此参数必填
     */
    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    private Long officialVersion;

    /**
     * @return 正式版本号
     */
    public Long getOfficialVersion() {
        return officialVersion;
    }

    /**
     * 设置正式版本号     *
     * 参数示例：<pre>0</pre>     
     * 此参数必填
     */
    public void setOfficialVersion(Long officialVersion) {
        this.officialVersion = officialVersion;
    }

    private String operatorName;

    /**
     * @return 操作人名
     */
    public String getOperatorName() {
        return operatorName;
    }

    /**
     * 设置操作人名     *
     * 参数示例：<pre>bon测试</pre>     
     * 此参数必填
     */
    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    private String orderCode;

    /**
     * @return 订单编号
     */
    public String getOrderCode() {
        return orderCode;
    }

    /**
     * 设置订单编号     *
     * 参数示例：<pre>WH201806030001</pre>     
     * 此参数必填
     */
    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    private Map orderTexts;

    /**
     * @return 订单文本(Key是文本类型Value是内容)
     */
    public Map getOrderTexts() {
        return orderTexts;
    }

    /**
     * 设置订单文本(Key是文本类型Value是内容)     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setOrderTexts(Map orderTexts) {
        this.orderTexts = orderTexts;
    }

    private String orderType;

    /**
     * @return 订单类型
     */
    public String getOrderType() {
        return orderType;
    }

    /**
     * 设置订单类型     *
     * 参数示例：<pre>standard</pre>     
     * 此参数必填
     */
    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    private String paymentType;

    /**
     * @return 付款方式
     */
    public String getPaymentType() {
        return paymentType;
    }

    /**
     * 设置付款方式     *
     * 参数示例：<pre>[\"transbybank\"]</pre>     
     * 此参数必填
     */
    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    private String phone;

    /**
     * @return 电话
     */
    public String getPhone() {
        return phone;
    }

    /**
     * 设置电话     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }

    private String post;

    /**
     * @return 邮编
     */
    public String getPost() {
        return post;
    }

    /**
     * 设置邮编     *
     * 参数示例：<pre>031100</pre>     
     * 此参数必填
     */
    public void setPost(String post) {
        this.post = post;
    }

    private AlibabaProcurementApiIntegrationModelIntegrationProcurementOrderEntryModel[] procurementOrderEntries;

    /**
     * @return 子单列表
     */
    public AlibabaProcurementApiIntegrationModelIntegrationProcurementOrderEntryModel[] getProcurementOrderEntries() {
        return procurementOrderEntries;
    }

    /**
     * 设置子单列表     *
     * 参数示例：<pre> </pre>     
     * 此参数必填
     */
    public void setProcurementOrderEntries(AlibabaProcurementApiIntegrationModelIntegrationProcurementOrderEntryModel[] procurementOrderEntries) {
        this.procurementOrderEntries = procurementOrderEntries;
    }

    private String receiverName;

    /**
     * @return 收货人姓名
     */
    public String getReceiverName() {
        return receiverName;
    }

    /**
     * 设置收货人姓名     *
     * 参数示例：<pre>JIxxxx</pre>     
     * 此参数必填
     */
    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    private String remark;

    /**
     * @return 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 设置备注     *
     * 参数示例：<pre>666</pre>     
     * 此参数必填
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    private String status;

    /**
     * @return 订单状态
     */
    public String getStatus() {
        return status;
    }

    /**
     * 设置订单状态     *
     * 参数示例：<pre>draft</pre>     
     * 此参数必填
     */
    public void setStatus(String status) {
        this.status = status;
    }

    private String supplierCode;

    /**
     * @return 供应商编码
     */
    public String getSupplierCode() {
        return supplierCode;
    }

    /**
     * 设置供应商编码     *
     * 参数示例：<pre>b-bceshi</pre>     
     * 此参数必填
     */
    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    private String supplierMemberId;

    /**
     * @return 供应商会员id
     */
    public String getSupplierMemberId() {
        return supplierMemberId;
    }

    /**
     * 设置供应商会员id     *
     * 参数示例：<pre>b-b220</pre>     
     * 此参数必填
     */
    public void setSupplierMemberId(String supplierMemberId) {
        this.supplierMemberId = supplierMemberId;
    }

    private String supplierName;

    /**
     * @return 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 设置供应商名称     *
     * 参数示例：<pre>xx供应商</pre>     
     * 此参数必填
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    private String totalCost;

    /**
     * @return 订单总费用
     */
    public String getTotalCost() {
        return totalCost;
    }

    /**
     * 设置订单总费用     *
     * 参数示例：<pre>120.23</pre>     
     * 此参数必填
     */
    public void setTotalCost(String totalCost) {
        this.totalCost = totalCost;
    }

    private String townName;

    /**
     * @return 街道或镇名称
     */
    public String getTownName() {
        return townName;
    }

    /**
     * 设置街道或镇名称     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setTownName(String townName) {
        this.townName = townName;
    }

    private String tradeType;

    /**
     * @return 交易方式
     */
    public String getTradeType() {
        return tradeType;
    }

    /**
     * 设置交易方式     *
     * 参数示例：<pre>alipay</pre>     
     * 此参数必填
     */
    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    private String buyerName;

    /**
     * @return 买家名称
     */
    public String getBuyerName() {
        return buyerName;
    }

    /**
     * 设置买家名称     *
     * 参数示例：<pre>xx买家</pre>     
     * 此参数必填
     */
    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    private String sendGoodsStatus;

    /**
     * @return 发货子状态
     */
    public String getSendGoodsStatus() {
        return sendGoodsStatus;
    }

    /**
     * 设置发货子状态     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setSendGoodsStatus(String sendGoodsStatus) {
        this.sendGoodsStatus = sendGoodsStatus;
    }

    private String receiveGoodsStatus;

    /**
     * @return 收货子状态
     */
    public String getReceiveGoodsStatus() {
        return receiveGoodsStatus;
    }

    /**
     * 设置收货子状态     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setReceiveGoodsStatus(String receiveGoodsStatus) {
        this.receiveGoodsStatus = receiveGoodsStatus;
    }

    private String settlementStatus;

    /**
     * @return 结算子状态
     */
    public String getSettlementStatus() {
        return settlementStatus;
    }

    /**
     * 设置结算子状态     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setSettlementStatus(String settlementStatus) {
        this.settlementStatus = settlementStatus;
    }

    private String payStatus;

    /**
     * @return 支付子状态
     */
    public String getPayStatus() {
        return payStatus;
    }

    /**
     * 设置支付子状态     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setPayStatus(String payStatus) {
        this.payStatus = payStatus;
    }

    private String invoiceStatus;

    /**
     * @return 发票子状态
     */
    public String getInvoiceStatus() {
        return invoiceStatus;
    }

    /**
     * 设置发票子状态     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setInvoiceStatus(String invoiceStatus) {
        this.invoiceStatus = invoiceStatus;
    }

    private String returnGoodsStatus;

    /**
     * @return 退货子状态
     */
    public String getReturnGoodsStatus() {
        return returnGoodsStatus;
    }

    /**
     * 设置退货子状态     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setReturnGoodsStatus(String returnGoodsStatus) {
        this.returnGoodsStatus = returnGoodsStatus;
    }

    private Boolean needSupplierConfirm;

    /**
     * @return 是否需要供应商确认订单
     */
    public Boolean getNeedSupplierConfirm() {
        return needSupplierConfirm;
    }

    /**
     * 设置是否需要供应商确认订单     *
     * 参数示例：<pre>false</pre>     
     * 此参数必填
     */
    public void setNeedSupplierConfirm(Boolean needSupplierConfirm) {
        this.needSupplierConfirm = needSupplierConfirm;
    }

    private String needInvoice;

    /**
     * @return 是否需要发票
     */
    public String getNeedInvoice() {
        return needInvoice;
    }

    /**
     * 设置是否需要发票     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setNeedInvoice(String needInvoice) {
        this.needInvoice = needInvoice;
    }

    private BigDecimal paidAmount;

    /**
     * @return 已付金额(单位元)
     */
    public BigDecimal getPaidAmount() {
        return paidAmount;
    }

    /**
     * 设置已付金额(单位元)     *
     * 参数示例：<pre>10.23</pre>     
     * 此参数必填
     */
    public void setPaidAmount(BigDecimal paidAmount) {
        this.paidAmount = paidAmount;
    }

    private BigDecimal actualAmount;

    /**
     * @return 应付金额(单位元)
     */
    public BigDecimal getActualAmount() {
        return actualAmount;
    }

    /**
     * 设置应付金额(单位元)     *
     * 参数示例：<pre>32.00</pre>     
     * 此参数必填
     */
    public void setActualAmount(BigDecimal actualAmount) {
        this.actualAmount = actualAmount;
    }

    private BigDecimal settledAmount;

    /**
     * @return 已结算金额(单位元)
     */
    public BigDecimal getSettledAmount() {
        return settledAmount;
    }

    /**
     * 设置已结算金额(单位元)     *
     * 参数示例：<pre>1.00</pre>     
     * 此参数必填
     */
    public void setSettledAmount(BigDecimal settledAmount) {
        this.settledAmount = settledAmount;
    }

    private BigDecimal waitSettleAmount;

    /**
     * @return 待结算金额(单位元)
     */
    public BigDecimal getWaitSettleAmount() {
        return waitSettleAmount;
    }

    /**
     * 设置待结算金额(单位元)     *
     * 参数示例：<pre>2.00</pre>     
     * 此参数必填
     */
    public void setWaitSettleAmount(BigDecimal waitSettleAmount) {
        this.waitSettleAmount = waitSettleAmount;
    }

    private Date gmtLastSettle;

    /**
     * @return 上次结算日期
     */
    public Date getGmtLastSettle() {
        return gmtLastSettle;
    }

    /**
     * 设置上次结算日期     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setGmtLastSettle(Date gmtLastSettle) {
        this.gmtLastSettle = gmtLastSettle;
    }

    private AlibabaProcurementApiBasicModelInvoiceAddressModel invoiceAddressModel;

    /**
     * @return 发票地址模型
     */
    public AlibabaProcurementApiBasicModelInvoiceAddressModel getInvoiceAddressModel() {
        return invoiceAddressModel;
    }

    /**
     * 设置发票地址模型     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setInvoiceAddressModel(AlibabaProcurementApiBasicModelInvoiceAddressModel invoiceAddressModel) {
        this.invoiceAddressModel = invoiceAddressModel;
    }

    private String buyerToSupplierRmk;

    /**
     * @return 买家对卖家附言
     */
    public String getBuyerToSupplierRmk() {
        return buyerToSupplierRmk;
    }

    /**
     * 设置买家对卖家附言     *
     * 参数示例：<pre>666</pre>     
     * 此参数必填
     */
    public void setBuyerToSupplierRmk(String buyerToSupplierRmk) {
        this.buyerToSupplierRmk = buyerToSupplierRmk;
    }

    private String supplierToBuyerRmk;

    /**
     * @return 卖家对买家附言
     */
    public String getSupplierToBuyerRmk() {
        return supplierToBuyerRmk;
    }

    /**
     * 设置卖家对买家附言     *
     * 参数示例：<pre>666</pre>     
     * 此参数必填
     */
    public void setSupplierToBuyerRmk(String supplierToBuyerRmk) {
        this.supplierToBuyerRmk = supplierToBuyerRmk;
    }

    private BigDecimal nonUnSettleAmount;

    /**
     * @return 发起结算金额
     */
    public BigDecimal getNonUnSettleAmount() {
        return nonUnSettleAmount;
    }

    /**
     * 设置发起结算金额     *
     * 参数示例：<pre>666</pre>     
     * 此参数必填
     */
    public void setNonUnSettleAmount(BigDecimal nonUnSettleAmount) {
        this.nonUnSettleAmount = nonUnSettleAmount;
    }

    private String companyName;

    /**
     * @return 公司名称
     */
    public String getCompanyName() {
        return companyName;
    }

    /**
     * 设置公司名称     *
     * 参数示例：<pre>xx公司</pre>     
     * 此参数必填
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    private String sourceBizType;

    /**
     * @return 来源业务类型
     */
    public String getSourceBizType() {
        return sourceBizType;
    }

    /**
     * 设置来源业务类型     *
     * 参数示例：<pre>quotation</pre>     
     * 此参数必填
     */
    public void setSourceBizType(String sourceBizType) {
        this.sourceBizType = sourceBizType;
    }

    private String supplierLoginId;

    /**
     * @return 供应商登录名
     */
    public String getSupplierLoginId() {
        return supplierLoginId;
    }

    /**
     * 设置供应商登录名     *
     * 参数示例：<pre>b测试账号003</pre>     
     * 此参数必填
     */
    public void setSupplierLoginId(String supplierLoginId) {
        this.supplierLoginId = supplierLoginId;
    }

}
