package cn.alibaba.open.param;

import java.util.*;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AlibabaProcurementApiOrderInteractiveModelInvoiceTemplateInfo {

    private String accountId;

    /**
     * @return 银行卡账号
     */
    public String getAccountId() {
        return accountId;
    }

    /**
     * 设置银行卡账号     *
     * 参数示例：<pre>333 333  444  555</pre>     
     * 此参数必填
     */
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    private String addressCode;

    /**
     * @return （注册）址区域编码
     */
    public String getAddressCode() {
        return addressCode;
    }

    /**
     * 设置（注册）址区域编码     *
     * 参数示例：<pre> </pre>     
     * 此参数必填
     */
    public void setAddressCode(String addressCode) {
        this.addressCode = addressCode;
    }

    private String addressCodeText;

    /**
     * @return （注册）地址区域编码对应的文本（国家，省，城市）
     */
    public String getAddressCodeText() {
        return addressCodeText;
    }

    /**
     * 设置（注册）地址区域编码对应的文本（国家，省，城市）     *
     * 参数示例：<pre> </pre>     
     * 此参数必填
     */
    public void setAddressCodeText(String addressCodeText) {
        this.addressCodeText = addressCodeText;
    }

    private String bank;

    /**
     * @return 开户银行
     */
    public String getBank() {
        return bank;
    }

    /**
     * 设置开户银行     *
     * 参数示例：<pre>招商银行</pre>     
     * 此参数必填
     */
    public void setBank(String bank) {
        this.bank = bank;
    }

    private AlibabaProcurementApiOrderInteractiveModelDeliveryAddress deliveryAddress;

    /**
     * @return 收货地址
     */
    public AlibabaProcurementApiOrderInteractiveModelDeliveryAddress getDeliveryAddress() {
        return deliveryAddress;
    }

    /**
     * 设置收货地址     *
     * 参数示例：<pre>杭州市网商路699号</pre>     
     * 此参数必填
     */
    public void setDeliveryAddress(AlibabaProcurementApiOrderInteractiveModelDeliveryAddress deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    private Long id;

    /**
     * @return 发票主键ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置发票主键ID     *
     * 参数示例：<pre>111</pre>     
     * 此参数必填
     */
    public void setId(Long id) {
        this.id = id;
    }

    private String phone;

    /**
     * @return 手机号
     */
    public String getPhone() {
        return phone;
    }

    /**
     * 设置手机号     *
     * 参数示例：<pre>12333333</pre>     
     * 此参数必填
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }

    private String shoppingShowURL;

    /**
     * @return 代购证明
     */
    public String getShoppingShowURL() {
        return shoppingShowURL;
    }

    /**
     * 设置代购证明     *
     * 参数示例：<pre>http://wwww.jpg</pre>     
     * 此参数必填
     */
    public void setShoppingShowURL(String shoppingShowURL) {
        this.shoppingShowURL = shoppingShowURL;
    }

    private String stressAddress;

    /**
     * @return （注册）街道地址，不包括省市编码
     */
    public String getStressAddress() {
        return stressAddress;
    }

    /**
     * 设置（注册）街道地址，不包括省市编码     *
     * 参数示例：<pre>杭州市网商路699号</pre>     
     * 此参数必填
     */
    public void setStressAddress(String stressAddress) {
        this.stressAddress = stressAddress;
    }

    private String taxpayerIdentify;

    /**
     * @return 纳税人识别号
     */
    public String getTaxpayerIdentify() {
        return taxpayerIdentify;
    }

    /**
     * 设置纳税人识别号     *
     * 参数示例：<pre>111111</pre>     
     * 此参数必填
     */
    public void setTaxpayerIdentify(String taxpayerIdentify) {
        this.taxpayerIdentify = taxpayerIdentify;
    }

    private String taxpayerShowURL;

    /**
     * @return 一般纳税人证明
     */
    public String getTaxpayerShowURL() {
        return taxpayerShowURL;
    }

    /**
     * 设置一般纳税人证明     *
     * 参数示例：<pre>http://wwww.jpg </pre>     
     * 此参数必填
     */
    public void setTaxpayerShowURL(String taxpayerShowURL) {
        this.taxpayerShowURL = taxpayerShowURL;
    }

    private Integer taxpayerType;

    /**
     * @return 一般纳税人证明类型
     */
    public Integer getTaxpayerType() {
        return taxpayerType;
    }

    /**
     * 设置一般纳税人证明类型     *
     * 参数示例：<pre> 无</pre>     
     * 此参数必填
     */
    public void setTaxpayerType(Integer taxpayerType) {
        this.taxpayerType = taxpayerType;
    }

    private String title;

    /**
     * @return 发票抬头
     */
    public String getTitle() {
        return title;
    }

    /**
     * 设置发票抬头     *
     * 参数示例：<pre>发票抬头</pre>     
     * 此参数必填
     */
    public void setTitle(String title) {
        this.title = title;
    }

    private Integer type;

    /**
     * @return 发票类型
     */
    public Integer getType() {
        return type;
    }

    /**
     * 设置发票类型     *
     * 参数示例：<pre>0:增值税发票（目前就一种）1:普通发票 </pre>     
     * 此参数必填
     */
    public void setType(Integer type) {
        this.type = type;
    }

    private Long userId;

    /**
     * @return 发票用户userId
     */
    public Long getUserId() {
        return userId;
    }

    /**
     * 设置发票用户userId     *
     * 参数示例：<pre> 无</pre>     
     * 此参数必填
     */
    public void setUserId(Long userId) {
        this.userId = userId;
    }

}
