package cn.alibaba.open.param;

import java.util.*;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AlibabaProcurementApiSettlementIntegrationModelIntegrationPayModel {

    private String actualPayChannel;

    /**
     * @return  最终付款使用的付款渠道
     */
    public String getActualPayChannel() {
        return actualPayChannel;
    }

    /**
     * 设置 最终付款使用的付款渠道     *
     * 参数示例：<pre>transbybank</pre>     
     * 此参数必填
     */
    public void setActualPayChannel(String actualPayChannel) {
        this.actualPayChannel = actualPayChannel;
    }

    private BigDecimal amount;

    /**
     * @return 付款金额
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /**
     * 设置付款金额     *
     * 参数示例：<pre> 100.00</pre>     
     * 此参数必填
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    private Long buyerMainUserId;

    /**
     * @return 买家主账号id
     */
    public Long getBuyerMainUserId() {
        return buyerMainUserId;
    }

    /**
     * 设置买家主账号id     *
     * 参数示例：<pre>123</pre>     
     * 此参数必填
     */
    public void setBuyerMainUserId(Long buyerMainUserId) {
        this.buyerMainUserId = buyerMainUserId;
    }

    private String buyerMemo;

    /**
     * @return 买家备注
     */
    public String getBuyerMemo() {
        return buyerMemo;
    }

    /**
     * 设置买家备注     *
     * 参数示例：<pre>xx</pre>     
     * 此参数必填
     */
    public void setBuyerMemo(String buyerMemo) {
        this.buyerMemo = buyerMemo;
    }

    private String buyerName;

    /**
     * @return 买家名字
     */
    public String getBuyerName() {
        return buyerName;
    }

    /**
     * 设置买家名字     *
     * 参数示例：<pre>xx</pre>     
     * 此参数必填
     */
    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    private String companyCode;

    /**
     * @return 数据字典公司code
     */
    public String getCompanyCode() {
        return companyCode;
    }

    /**
     * 设置数据字典公司code     *
     * 参数示例：<pre>xx</pre>     
     * 此参数必填
     */
    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    private String companyName;

    /**
     * @return 买家数据字典公司名称
     */
    public String getCompanyName() {
        return companyName;
    }

    /**
     * 设置买家数据字典公司名称     *
     * 参数示例：<pre>xx</pre>     
     * 此参数必填
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    private AlibabaProcurementApiSettlementIntegrationModelIntegrationPayEntryModel[] entryList;

    /**
     * @return 付款子单列表
     */
    public AlibabaProcurementApiSettlementIntegrationModelIntegrationPayEntryModel[] getEntryList() {
        return entryList;
    }

    /**
     * 设置付款子单列表     *
     * 参数示例：<pre>[]</pre>     
     * 此参数必填
     */
    public void setEntryList(AlibabaProcurementApiSettlementIntegrationModelIntegrationPayEntryModel[] entryList) {
        this.entryList = entryList;
    }

    private Date gmtCreate;

    /**
     * @return 创建时间
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * 设置创建时间     *
     * 参数示例：<pre>20190917110700565+0800</pre>     
     * 此参数必填
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    private Date gmtModified;

    /**
     * @return 最后修改时间
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * 设置最后修改时间     *
     * 参数示例：<pre>20190917110700565+0800</pre>     
     * 此参数必填
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    private Date gmtPayEnd;

    /**
     * @return <pre>
    付款单完成时间，付款到账后更新

    一次性付款为单次付款的是时间
    多次付款为最后一笔付款的时间
    取消付款单，没有值
    </pre>
     */
    public Date getGmtPayEnd() {
        return gmtPayEnd;
    }

    /**
     * 设置<pre>
    付款单完成时间，付款到账后更新

    一次性付款为单次付款的是时间
    多次付款为最后一笔付款的时间
    取消付款单，没有值
    </pre>     *
     * 参数示例：<pre>20190917110700565+0800</pre>     
     * 此参数必填
     */
    public void setGmtPayEnd(Date gmtPayEnd) {
        this.gmtPayEnd = gmtPayEnd;
    }

    private Long id;

    /**
     * @return 付款单ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置付款单ID     *
     * 参数示例：<pre>123</pre>     
     * 此参数必填
     */
    public void setId(Long id) {
        this.id = id;
    }

    private BigDecimal paidAmount;

    /**
     * @return 已付款金额
     */
    public BigDecimal getPaidAmount() {
        return paidAmount;
    }

    /**
     * 设置已付款金额     *
     * 参数示例：<pre>100.00</pre>     
     * 此参数必填
     */
    public void setPaidAmount(BigDecimal paidAmount) {
        this.paidAmount = paidAmount;
    }

    private String payChannels;

    /**
     * @return 付款单可用付款渠道：transbybank:对公转账；mybanketicket：电票；ptransbybank：对私转账；alipay：支付宝
     */
    public String getPayChannels() {
        return payChannels;
    }

    /**
     * 设置付款单可用付款渠道：transbybank:对公转账；mybanketicket：电票；ptransbybank：对私转账；alipay：支付宝     *
     * 参数示例：<pre>["transbybank","mybanketicket"]</pre>     
     * 此参数必填
     */
    public void setPayChannels(String payChannels) {
        this.payChannels = payChannels;
    }

    private String payNo;

    /**
     * @return 付款单编号
     */
    public String getPayNo() {
        return payNo;
    }

    /**
     * 设置付款单编号     *
     * 参数示例：<pre>20201223423423</pre>     
     * 此参数必填
     */
    public void setPayNo(String payNo) {
        this.payNo = payNo;
    }

    private String payStatus;

    /**
     * @return 付款状态
     */
    public String getPayStatus() {
        return payStatus;
    }

    /**
     * 设置付款状态     *
     * 参数示例：<pre>付款单付款状态：init:未付款；partPaid：部分付款；payOff：付款完成</pre>     
     * 此参数必填
     */
    public void setPayStatus(String payStatus) {
        this.payStatus = payStatus;
    }

    private String status;

    /**
     * @return 付款单流程状态
     */
    public String getStatus() {
        return status;
    }

    /**
     * 设置付款单流程状态     *
     * 参数示例：<pre>付款单单据状态：init:已生效；success：付款单已完结；cancel：付款单已取消</pre>     
     * 此参数必填
     */
    public void setStatus(String status) {
        this.status = status;
    }

    private String supplierCode;

    /**
     * @return 供应商编码
     */
    public String getSupplierCode() {
        return supplierCode;
    }

    /**
     * 设置供应商编码     *
     * 参数示例：<pre>xx</pre>     
     * 此参数必填
     */
    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    private Long supplierMainUserId;

    /**
     * @return 卖家主账号id
     */
    public Long getSupplierMainUserId() {
        return supplierMainUserId;
    }

    /**
     * 设置卖家主账号id     *
     * 参数示例：<pre>123</pre>     
     * 此参数必填
     */
    public void setSupplierMainUserId(Long supplierMainUserId) {
        this.supplierMainUserId = supplierMainUserId;
    }

    private String supplierMobile;

    /**
     * @return 供应商手机
     */
    public String getSupplierMobile() {
        return supplierMobile;
    }

    /**
     * 设置供应商手机     *
     * 参数示例：<pre>xx</pre>     
     * 此参数必填
     */
    public void setSupplierMobile(String supplierMobile) {
        this.supplierMobile = supplierMobile;
    }

    private String supplierName;

    /**
     * @return 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 设置供应商名称     *
     * 参数示例：<pre>xx</pre>     
     * 此参数必填
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    private String supplierPhone;

    /**
     * @return 供应商电话
     */
    public String getSupplierPhone() {
        return supplierPhone;
    }

    /**
     * 设置供应商电话     *
     * 参数示例：<pre>13133333333</pre>     
     * 此参数必填
     */
    public void setSupplierPhone(String supplierPhone) {
        this.supplierPhone = supplierPhone;
    }

    private String creatorName;

    /**
     * @return 创建人名称
     */
    public String getCreatorName() {
        return creatorName;
    }

    /**
     * 设置创建人名称     *
     * 参数示例：<pre>XX</pre>     
     * 此参数必填
     */
    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    private Long creatorUserId;

    /**
     * @return 创建人用户ID
     */
    public Long getCreatorUserId() {
        return creatorUserId;
    }

    /**
     * 设置创建人用户ID     *
     * 参数示例：<pre>123</pre>     
     * 此参数必填
     */
    public void setCreatorUserId(Long creatorUserId) {
        this.creatorUserId = creatorUserId;
    }

    private String tradeSettleId;

    /**
     * @return 交易结算单id
     */
    public String getTradeSettleId() {
        return tradeSettleId;
    }

    /**
     * 设置交易结算单id     *
     * 参数示例：<pre>2144312</pre>     
     * 此参数必填
     */
    public void setTradeSettleId(String tradeSettleId) {
        this.tradeSettleId = tradeSettleId;
    }

    private String supplierMemberId;

    /**
     * @return 供应商memberId
     */
    public String getSupplierMemberId() {
        return supplierMemberId;
    }

    /**
     * 设置供应商memberId     *
     * 参数示例：<pre>b2b-nnjdju</pre>     
     * 此参数必填
     */
    public void setSupplierMemberId(String supplierMemberId) {
        this.supplierMemberId = supplierMemberId;
    }

}
