package cn.alibaba.open.param;

import java.util.*;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BusinessInfo {

    private String businessModel;

    /**
     * @return 经营模式
     */
    public String getBusinessModel() {
        return businessModel;
    }

    /**
     * 设置经营模式     *
     * 参数示例：<pre>返回结果包含:枚举类型:经销批发;生产加工;招商代理;商业服务;其他; 五个结果.</pre>     
     * 此参数必填
     */
    public void setBusinessModel(String businessModel) {
        this.businessModel = businessModel;
    }

    private String mainIndustries;

    /**
     * @return 主营行业
     */
    public String getMainIndustries() {
        return mainIndustries;
    }

    /**
     * 设置主营行业     *
     * 参数示例：<pre>该字段为用户自由填写.没有固定格式.例如:童装\婴幼儿服装、内衣</pre>     
     * 此参数必填
     */
    public void setMainIndustries(String mainIndustries) {
        this.mainIndustries = mainIndustries;
    }

    private String[] productionService;

    /**
     * @return 主营产品/服务
     */
    public String[] getProductionService() {
        return productionService;
    }

    /**
     * 设置主营产品/服务     *
     * 参数示例：<pre>该字段为用户自由填写.没有固定格式.</pre>     
     * 此参数必填
     */
    public void setProductionService(String[] productionService) {
        this.productionService = productionService;
    }

    private String brandName;

    /**
     * @return 品牌名称
     */
    public String getBrandName() {
        return brandName;
    }

    /**
     * 设置品牌名称     *
     * 参数示例：<pre>该字段为用户自由填写.没有固定格式.例如:
    槽钢.角钢.钢板 圆钢.工字钢 H型钢.方矩管 方管.镀锌管 C型槽.彩瓦</pre>     
     * 此参数必填
     */
    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    private String businessAddress;

    /**
     * @return 经营地址
     */
    public String getBusinessAddress() {
        return businessAddress;
    }

    /**
     * 设置经营地址     *
     * 参数示例：<pre>省份(空格)城市</pre>     
     * 此参数必填
     */
    public void setBusinessAddress(String businessAddress) {
        this.businessAddress = businessAddress;
    }

    private String enterpriseType;

    /**
     * @return 企业类型/公司类型
     */
    public String getEnterpriseType() {
        return enterpriseType;
    }

    /**
     * 设置企业类型/公司类型     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setEnterpriseType(String enterpriseType) {
        this.enterpriseType = enterpriseType;
    }

}
