package cn.alibaba.open.param;

import com.alibaba.ocean.rawsdk.client.APIId;
import com.alibaba.ocean.rawsdk.common.AbstractAPIRequest;

import java.util.*;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CaigouApiAccountCreateSubAccountParam extends AbstractAPIRequest<CaigouApiAccountCreateSubAccountResult> {

    public CaigouApiAccountCreateSubAccountParam() {
        super();
        oceanApiId = new APIId("cn.alibaba.open", "caigou.api.account.createSubAccount", 2);
    }

    private String employeeId;

    /**
     * @return 需要创建的子帐号在接入商系统内部唯一编号或者ID
     */
    public String getEmployeeId() {
        return employeeId;
    }

    /**
     * 设置需要创建的子帐号在接入商系统内部唯一编号或者ID     *
     * 参数示例：<pre>001</pre>     
     * 此参数必填
     */
    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    private String name;

    /**
     * @return 需要创建的子帐号的姓名
     */
    public String getName() {
        return name;
    }

    /**
     * 设置需要创建的子帐号的姓名     *
     * 参数示例：<pre>张三</pre>     
     * 此参数必填
     */
    public void setName(String name) {
        this.name = name;
    }

    private String mobileNo;

    /**
     * @return 需要创建的子帐号的手机号，如果为空的话将来无法收到来自1688的采购业务提醒
     */
    public String getMobileNo() {
        return mobileNo;
    }

    /**
     * 设置需要创建的子帐号的手机号，如果为空的话将来无法收到来自1688的采购业务提醒     *
     * 参数示例：<pre>13500000000</pre>     
     * 此参数必填
     */
    public void setMobileNo(String mobileNo) {
        this.mobileNo = mobileNo;
    }

    private String email;

    /**
     * @return 需要创建的子帐号的邮箱，如果为空则无法收到来自1688采购业务的邮件提醒
     */
    public String getEmail() {
        return email;
    }

    /**
     * 设置需要创建的子帐号的邮箱，如果为空则无法收到来自1688采购业务的邮件提醒     *
     * 参数示例：<pre>aaa@aliyun.com</pre>     
     * 此参数必填
     */
    public void setEmail(String email) {
        this.email = email;
    }

    private String sex;

    /**
     * @return 需要创建的子帐号的性别，枚举值：1或者2；1表示男，2表示女
     */
    public String getSex() {
        return sex;
    }

    /**
     * 设置需要创建的子帐号的性别，枚举值：1或者2；1表示男，2表示女     *
     * 参数示例：<pre>1</pre>     
     * 此参数必填
     */
    public void setSex(String sex) {
        this.sex = sex;
    }

    private String department;

    /**
     * @return 需要创建的子帐号所属部门，多级部门用"-"分割，最多三级；如果为空，系统默认会在主帐号下面创建一个“我的团队”这个部门，所有没有传部门的子帐号都会归属到这个默认部门下面去。
     */
    public String getDepartment() {
        return department;
    }

    /**
     * 设置需要创建的子帐号所属部门，多级部门用"-"分割，最多三级；如果为空，系统默认会在主帐号下面创建一个“我的团队”这个部门，所有没有传部门的子帐号都会归属到这个默认部门下面去。     *
     * 参数示例：<pre>采购部-采购一部-采购一组</pre>     
     * 此参数必填
     */
    public void setDepartment(String department) {
        this.department = department;
    }

    private String role;

    /**
     * @return 需要创建的子帐号在1688帐号体系下的角色，枚举值为：采购员、采购经理、财务，如果为空的话这个子帐号就没有相关采购寻源的权限或者采购的权限
     */
    public String getRole() {
        return role;
    }

    /**
     * 设置需要创建的子帐号在1688帐号体系下的角色，枚举值为：采购员、采购经理、财务，如果为空的话这个子帐号就没有相关采购寻源的权限或者采购的权限     *
     * 参数示例：<pre>采购员</pre>     
     * 此参数必填
     */
    public void setRole(String role) {
        this.role = role;
    }

    private String authCompanies;

    /**
     * @return 授权公司编码，多个用英文分号分隔
     */
    public String getAuthCompanies() {
        return authCompanies;
    }

    /**
     * 设置授权公司编码，多个用英文分号分隔     *
     * 参数示例：<pre>c001;c002;c003</pre>     
     * 此参数必填
     */
    public void setAuthCompanies(String authCompanies) {
        this.authCompanies = authCompanies;
    }

    private String authFactories;

    /**
     * @return 授权工厂编码，多个用英文分号分隔
     */
    public String getAuthFactories() {
        return authFactories;
    }

    /**
     * 设置授权工厂编码，多个用英文分号分隔     *
     * 参数示例：<pre>f001;f002;f003</pre>     
     * 此参数必填
     */
    public void setAuthFactories(String authFactories) {
        this.authFactories = authFactories;
    }

    private String authPurchaseCenters;

    /**
     * @return 授权采购中心编码，多个用英文分号分隔
     */
    public String getAuthPurchaseCenters() {
        return authPurchaseCenters;
    }

    /**
     * 设置授权采购中心编码，多个用英文分号分隔     *
     * 参数示例：<pre>pc001;pc002;pc003</pre>     
     * 此参数必填
     */
    public void setAuthPurchaseCenters(String authPurchaseCenters) {
        this.authPurchaseCenters = authPurchaseCenters;
    }

    private String authCostCenters;

    /**
     * @return 授权成本中心，格式：公司编码|成本中心编码   多个成本中心用英文分号分隔
     */
    public String getAuthCostCenters() {
        return authCostCenters;
    }

    /**
     * 设置授权成本中心，格式：公司编码|成本中心编码   多个成本中心用英文分号分隔     *
     * 参数示例：<pre>c001|cc123;c002|cc098</pre>     
     * 此参数必填
     */
    public void setAuthCostCenters(String authCostCenters) {
        this.authCostCenters = authCostCenters;
    }

    private String authAreas;

    /**
     * @return 授权区域名称，多个用英文分号分隔
     */
    public String getAuthAreas() {
        return authAreas;
    }

    /**
     * 设置授权区域名称，多个用英文分号分隔     *
     * 参数示例：<pre>上海;广州</pre>     
     * 此参数必填
     */
    public void setAuthAreas(String authAreas) {
        this.authAreas = authAreas;
    }

    private String authCategories;

    /**
     * @return 授权类目编码，多个用英文分号分隔 (此处传一级类目编码)
     */
    public String getAuthCategories() {
        return authCategories;
    }

    /**
     * 设置授权类目编码，多个用英文分号分隔 (此处传一级类目编码)     *
     * 参数示例：<pre>017</pre>     
     * 此参数必填
     */
    public void setAuthCategories(String authCategories) {
        this.authCategories = authCategories;
    }

    private String securityPhone;

    /**
     * @return 安全手机号码
     */
    public String getSecurityPhone() {
        return securityPhone;
    }

    /**
     * 设置安全手机号码     *
     * 参数示例：<pre>13112832378</pre>     
     * 此参数必填
     */
    public void setSecurityPhone(String securityPhone) {
        this.securityPhone = securityPhone;
    }

    private String passWord;

    /**
     * @return 账号登录密码
     */
    public String getPassWord() {
        return passWord;
    }

    /**
     * 设置账号登录密码     *
     * 参数示例：<pre>taobao1234</pre>     
     * 此参数必填
     */
    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    private String employeePrefix;

    /**
     * @return 字符串"1"：代表子账号不加任何前缀     其他情况:代表子账号默认加"cg"前缀
     */
    public String getEmployeePrefix() {
        return employeePrefix;
    }

    /**
     * 设置字符串"1"：代表子账号不加任何前缀     其他情况:代表子账号默认加"cg"前缀     *
     * 参数示例：<pre>1</pre>     
     * 此参数必填
     */
    public void setEmployeePrefix(String employeePrefix) {
        this.employeePrefix = employeePrefix;
    }

    private String departmentCode;

    /**
     * @return 依赖于"department"字段，如果多级需要与之对应，用"-"分割
     */
    public String getDepartmentCode() {
        return departmentCode;
    }

    /**
     * 设置依赖于"department"字段，如果多级需要与之对应，用"-"分割     *
     * 参数示例：<pre>1-2-3</pre>     
     * 此参数必填
     */
    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }

}
