package cn.alibaba.open.param;

import com.alibaba.ocean.rawsdk.client.APIId;
import com.alibaba.ocean.rawsdk.common.AbstractAPIRequest;

import java.util.*;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CaigouApiAttachmentUploadParam extends AbstractAPIRequest<CaigouApiAttachmentUploadResult> {

    public CaigouApiAttachmentUploadParam() {
        super();
        oceanApiId = new APIId("cn.alibaba.open", "caigou.api.attachment.upload", 1);
    }

    private String name;

    /**
     * @return 文件名。最大字符为64个英文和汉子字符或者21个汉字。超过部分会被强制截断.
     */
    public String getName() {
        return name;
    }

    /**
     * 设置文件名。最大字符为64个英文和汉子字符或者21个汉字。超过部分会被强制截断.     *
     * 参数示例：<pre>刚才详细说明.pdf</pre>     
     * 此参数必填
     */
    public void setName(String name) {
        this.name = name;
    }

    private byte[] fileBytes;

    /**
     * @return 附件的二进制数据，向服务端提交文件即可 (fileBytes这个参数不能签名)。使用 enctype="multipart/form-data" 的POST文件上传方式提交数据
     */
    public byte[] getFileBytes() {
        return fileBytes;
    }

    /**
     * 设置附件的二进制数据，向服务端提交文件即可 (fileBytes这个参数不能签名)。使用 enctype="multipart/form-data" 的POST文件上传方式提交数据     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setFileBytes(byte[] fileBytes) {
        this.fileBytes = fileBytes;
    }

}
