package cn.alibaba.open.param;

import com.alibaba.ocean.rawsdk.client.APIId;
import com.alibaba.ocean.rawsdk.common.AbstractAPIRequest;

import java.util.*;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CaigouApiBuyofferCloseBuyOfferParam extends AbstractAPIRequest<CaigouApiBuyofferCloseBuyOfferResult> {

    public CaigouApiBuyofferCloseBuyOfferParam() {
        super();
        oceanApiId = new APIId("cn.alibaba.open", "caigou.api.buyoffer.closeBuyOffer", 1);
    }

    private Long buyOfferId;

    /**
     * @return 询价单Id
     */
    public Long getBuyOfferId() {
        return buyOfferId;
    }

    /**
     * 设置询价单Id     *
     * 参数示例：<pre>70012132</pre>     
     * 此参数必填
     */
    public void setBuyOfferId(Long buyOfferId) {
        this.buyOfferId = buyOfferId;
    }

    private String closeReason;

    /**
     * @return 关闭询价单原因【不要超过20个字符】
     */
    public String getCloseReason() {
        return closeReason;
    }

    /**
     * 设置关闭询价单原因【不要超过20个字符】     *
     * 参数示例：<pre>未收到合适的报价</pre>     
     * 此参数必填
     */
    public void setCloseReason(String closeReason) {
        this.closeReason = closeReason;
    }

    private String closeDesc;

    /**
     * @return 关闭询价单详细描述【不要超过40个字符】
     */
    public String getCloseDesc() {
        return closeDesc;
    }

    /**
     * 设置关闭询价单详细描述【不要超过40个字符】     *
     * 参数示例：<pre>这些价格要么比较贵，要么没有找到合适的供应商。</pre>     
     * 此参数必填
     */
    public void setCloseDesc(String closeDesc) {
        this.closeDesc = closeDesc;
    }

}
