package cn.alibaba.open.param;

import com.alibaba.ocean.rawsdk.client.APIId;
import com.alibaba.ocean.rawsdk.common.AbstractAPIRequest;

import java.util.*;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CaigouApiBuyofferPostBuyofferParam extends AbstractAPIRequest<CaigouApiBuyofferPostBuyofferResult> {

    public CaigouApiBuyofferPostBuyofferParam() {
        super();
        oceanApiId = new APIId("cn.alibaba.open", "caigou.api.buyoffer.postBuyoffer", 1);
    }

    private String subject;

    /**
     * @return 询价单标题(不能超过80个字符)
     */
    public String getSubject() {
        return subject;
    }

    /**
     * 设置询价单标题(不能超过80个字符)     *
     * 参数示例：<pre>采购圆珠笔</pre>     
     * 此参数必填
     */
    public void setSubject(String subject) {
        this.subject = subject;
    }

    private Long subUserId;

    /**
     * @return 买家子账号userId.这个id同创建子账号接口的返回值。如果不创建子账号，可以不传值！
     */
    public Long getSubUserId() {
        return subUserId;
    }

    /**
     * 设置买家子账号userId.这个id同创建子账号接口的返回值。如果不创建子账号，可以不传值！     *
     * 参数示例：<pre>3605512031</pre>     
     * 此参数必填
     */
    public void setSubUserId(Long subUserId) {
        this.subUserId = subUserId;
    }

    private String contact;

    /**
     * @return 采购联系人(不能超过20个字符)
     */
    public String getContact() {
        return contact;
    }

    /**
     * 设置采购联系人(不能超过20个字符)     *
     * 参数示例：<pre>高先生</pre>     
     * 此参数必填
     */
    public void setContact(String contact) {
        this.contact = contact;
    }

    private String phone;

    /**
     * @return 联系人电话(不能超过40个字符)
     */
    public String getPhone() {
        return phone;
    }

    /**
     * 设置联系人电话(不能超过40个字符)     *
     * 参数示例：<pre>13485296352</pre>     
     * 此参数必填
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }

    private String description;

    /**
     * @return 补充说明描述(不能超过10000个字符)
     */
    public String getDescription() {
        return description;
    }

    /**
     * 设置补充说明描述(不能超过10000个字符)     *
     * 参数示例：<pre>物品要实惠，价格要优惠</pre>     
     * 此参数必填
     */
    public void setDescription(String description) {
        this.description = description;
    }

    private Date gmtQuotationExpire;

    /**
     * @return 报价截止日期(过期后供应商不能报价)
     */
    public Date getGmtQuotationExpire() {
        return gmtQuotationExpire;
    }

    /**
     * 设置报价截止日期(过期后供应商不能报价)     *
     * 参数示例：<pre>20140801154220368+0800</pre>     
     * 此参数必填
     */
    public void setGmtQuotationExpire(Date gmtQuotationExpire) {
        this.gmtQuotationExpire = gmtQuotationExpire;
    }

    private String receiveAddressProvince;

    /**
     * @return 收货地(省<国标>6个字符)
     */
    public String getReceiveAddressProvince() {
        return receiveAddressProvince;
    }

    /**
     * 设置收货地(省<国标>6个字符)     *
     * 参数示例：<pre>210000</pre>     
     * 此参数必填
     */
    public void setReceiveAddressProvince(String receiveAddressProvince) {
        this.receiveAddressProvince = receiveAddressProvince;
    }

    private String receiveAddressCity;

    /**
     * @return 收货地(市<国标>6个字符)
     */
    public String getReceiveAddressCity() {
        return receiveAddressCity;
    }

    /**
     * 设置收货地(市<国标>6个字符)     *
     * 参数示例：<pre>211400</pre>     
     * 此参数必填
     */
    public void setReceiveAddressCity(String receiveAddressCity) {
        this.receiveAddressCity = receiveAddressCity;
    }

    private String receiveAddressCounty;

    /**
     * @return 收货地(区<国标>6个字符)
     */
    public String getReceiveAddressCounty() {
        return receiveAddressCounty;
    }

    /**
     * 设置收货地(区<国标>6个字符)     *
     * 参数示例：<pre>211421</pre>     
     * 此参数必填
     */
    public void setReceiveAddressCounty(String receiveAddressCounty) {
        this.receiveAddressCounty = receiveAddressCounty;
    }

    private List expectedSupplierAreas;

    /**
     * @return 【报价资质】-经营地址<国标>
     */
    public List getExpectedSupplierAreas() {
        return expectedSupplierAreas;
    }

    /**
     * 设置【报价资质】-经营地址<国标>     *
     * 参数示例：<pre>["331100","610300"]</pre>     
     * 此参数必填
     */
    public void setExpectedSupplierAreas(List expectedSupplierAreas) {
        this.expectedSupplierAreas = expectedSupplierAreas;
    }

    private String invoiceRequirement;

    /**
     * @return 【报价资质】-发票要求(vat:增值税专票--不限开具方 ; ordinary:增值税普通发票 ; none:不用发票)
     */
    public String getInvoiceRequirement() {
        return invoiceRequirement;
    }

    /**
     * 设置【报价资质】-发票要求(vat:增值税专票--不限开具方 ; ordinary:增值税普通发票 ; none:不用发票)     *
     * 参数示例：<pre>vat</pre>     
     * 此参数必填
     */
    public void setInvoiceRequirement(String invoiceRequirement) {
        this.invoiceRequirement = invoiceRequirement;
    }

    private Boolean supportAlipayGuaranteeTrade;

    /**
     * @return 【报价资质】-是否支持支付宝担保交易(true/false)
     */
    public Boolean getSupportAlipayGuaranteeTrade() {
        return supportAlipayGuaranteeTrade;
    }

    /**
     * 设置【报价资质】-是否支持支付宝担保交易(true/false)     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setSupportAlipayGuaranteeTrade(Boolean supportAlipayGuaranteeTrade) {
        this.supportAlipayGuaranteeTrade = supportAlipayGuaranteeTrade;
    }

    private List certificateIds;

    /**
     * @return 【报价资质】-证照要求，具体值如下：1(营业执照), 2(税务登记证), 3(组织机构代码证), 12(国际和国内的产品认证证书), 37(环境管理体系认证证书), 38(企业质量管理体系认证证书), 4(外商投资企业批准证书(外资企业必须)), 103(其他), 400(税务登记证副本（加盖增值税一般纳税人印章）), 5(食品生产许可证 ), 6(酒类生产许可证), 7(化妆品生产许可证), 8(药品生产许可证), 25(安全生产许可证 ), 26(医疗器械生产企业许可证), 27(制造计量器具许可证), 28(特种设备制造许可证（包括压力容器）), 29(建筑业企业资质证书), 30(排放污染物许可证 ), 31(烟草专卖许可证), 32(药品经营许可证), 33(危险化学品经营许可证), 34(烟花爆竹零售经营许可), 35(食品经营许可证), 36(餐饮服务许可证), 39(其他), 101(道路运输经营许可证), 102(印刷经营许可证), 201(食品流通许可证), 202(食品卫生许可证), 203(酒类流通备案登记表), 204(酒类商品批发许可证), 205(酒类商品零售许可证), 206(酒类产销许可证), 207(进口货物报关单), 208(商品出入境检验检疫合格证明), 209(出入境检验检疫卫生证书), 9(产品质量监督检查证书), 10(品牌授权书(如驰名商标、行业知名品牌)), 11(区域代理授权书), 16(纺织品生态标签发明专利、外观设计专利、实用新型外观设计类证书), 17(商标注册证), 19(其他), 20(荣誉证书，如消费者协会荣誉证书、行业协会荣誉证书、重合同守信用证书), 21(银行资信类证书、银行评级证明), 22(开户许可证), 23(公司证明、人事证明、纳税证明)
     */
    public List getCertificateIds() {
        return certificateIds;
    }

    /**
     * 设置【报价资质】-证照要求，具体值如下：1(营业执照), 2(税务登记证), 3(组织机构代码证), 12(国际和国内的产品认证证书), 37(环境管理体系认证证书), 38(企业质量管理体系认证证书), 4(外商投资企业批准证书(外资企业必须)), 103(其他), 400(税务登记证副本（加盖增值税一般纳税人印章）), 5(食品生产许可证 ), 6(酒类生产许可证), 7(化妆品生产许可证), 8(药品生产许可证), 25(安全生产许可证 ), 26(医疗器械生产企业许可证), 27(制造计量器具许可证), 28(特种设备制造许可证（包括压力容器）), 29(建筑业企业资质证书), 30(排放污染物许可证 ), 31(烟草专卖许可证), 32(药品经营许可证), 33(危险化学品经营许可证), 34(烟花爆竹零售经营许可), 35(食品经营许可证), 36(餐饮服务许可证), 39(其他), 101(道路运输经营许可证), 102(印刷经营许可证), 201(食品流通许可证), 202(食品卫生许可证), 203(酒类流通备案登记表), 204(酒类商品批发许可证), 205(酒类商品零售许可证), 206(酒类产销许可证), 207(进口货物报关单), 208(商品出入境检验检疫合格证明), 209(出入境检验检疫卫生证书), 9(产品质量监督检查证书), 10(品牌授权书(如驰名商标、行业知名品牌)), 11(区域代理授权书), 16(纺织品生态标签发明专利、外观设计专利、实用新型外观设计类证书), 17(商标注册证), 19(其他), 20(荣誉证书，如消费者协会荣誉证书、行业协会荣誉证书、重合同守信用证书), 21(银行资信类证书、银行评级证明), 22(开户许可证), 23(公司证明、人事证明、纳税证明)     *
     * 参数示例：<pre>["1","2"]</pre>     
     * 此参数必填
     */
    public void setCertificateIds(List certificateIds) {
        this.certificateIds = certificateIds;
    }

    private List otherCertificateNames;

    /**
     * @return 【报价资质】-其他证书名称(不能超过165个字符)
     */
    public List getOtherCertificateNames() {
        return otherCertificateNames;
    }

    /**
     * 设置【报价资质】-其他证书名称(不能超过165个字符)     *
     * 参数示例：<pre>["诚信电商证书"]</pre>     
     * 此参数必填
     */
    public void setOtherCertificateNames(List otherCertificateNames) {
        this.otherCertificateNames = otherCertificateNames;
    }

    private Long regCapital;

    /**
     * @return 【报价资质】-注册资金(万元)
     */
    public Long getRegCapital() {
        return regCapital;
    }

    /**
     * 设置【报价资质】-注册资金(万元)     *
     * 参数示例：<pre>100</pre>     
     * 此参数必填
     */
    public void setRegCapital(Long regCapital) {
        this.regCapital = regCapital;
    }

    private String prId;

    /**
     * @return 外部系统的采购需求的id (不要大于64个英文或数字字符)
     */
    public String getPrId() {
        return prId;
    }

    /**
     * 设置外部系统的采购需求的id (不要大于64个英文或数字字符)     *
     * 参数示例：<pre>pr00001</pre>     
     * 此参数必填
     */
    public void setPrId(String prId) {
        this.prId = prId;
    }

    private List attachmentIdList;

    /**
     * @return 附件id集合，附件id来源于上传附件的接口。
     */
    public List getAttachmentIdList() {
        return attachmentIdList;
    }

    /**
     * 设置附件id集合，附件id来源于上传附件的接口。     *
     * 参数示例：<pre>[843860048803,843860029973]</pre>     
     * 此参数必填
     */
    public void setAttachmentIdList(List attachmentIdList) {
        this.attachmentIdList = attachmentIdList;
    }

    private Boolean visibleAfterEndQuote;

    /**
     * @return 【询价方式及隐私】-比价方式((true:密封比价(未到截止日期不可查看报价) ；false:非密封比价))
     */
    public Boolean getVisibleAfterEndQuote() {
        return visibleAfterEndQuote;
    }

    /**
     * 设置【询价方式及隐私】-比价方式((true:密封比价(未到截止日期不可查看报价) ；false:非密封比价))     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setVisibleAfterEndQuote(Boolean visibleAfterEndQuote) {
        this.visibleAfterEndQuote = visibleAfterEndQuote;
    }

    private Boolean includeTax;

    /**
     * @return 【采购要求】-报价要求-报价含税(true/false)
     */
    public Boolean getIncludeTax() {
        return includeTax;
    }

    /**
     * 设置【采购要求】-报价要求-报价含税(true/false)     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setIncludeTax(Boolean includeTax) {
        this.includeTax = includeTax;
    }

    private Boolean quoteHasPostFee;

    /**
     * @return 【采购要求】-报价要求-报价需要包含运费(true/false)
     */
    public Boolean getQuoteHasPostFee() {
        return quoteHasPostFee;
    }

    /**
     * 设置【采购要求】-报价要求-报价需要包含运费(true/false)     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setQuoteHasPostFee(Boolean quoteHasPostFee) {
        this.quoteHasPostFee = quoteHasPostFee;
    }

    private Boolean allowPartOffer;

    /**
     * @return 【采购要求】-报价要求-允许对询价单部分物料报价(true/false)
     */
    public Boolean getAllowPartOffer() {
        return allowPartOffer;
    }

    /**
     * 设置【采购要求】-报价要求-允许对询价单部分物料报价(true/false)     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setAllowPartOffer(Boolean allowPartOffer) {
        this.allowPartOffer = allowPartOffer;
    }

    private Boolean open;

    /**
     * @return 【基础信息】-公开与邀请(true/false)
     */
    public Boolean getOpen() {
        return open;
    }

    /**
     * 设置【基础信息】-公开与邀请(true/false)     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setOpen(Boolean open) {
        this.open = open;
    }

    private Boolean openToPortal;

    /**
     * @return 【询价方式及隐私】-公开采购门户(true/false)
     */
    public Boolean getOpenToPortal() {
        return openToPortal;
    }

    /**
     * 设置【询价方式及隐私】-公开采购门户(true/false)     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setOpenToPortal(Boolean openToPortal) {
        this.openToPortal = openToPortal;
    }

    private String processTemplateCode;

    /**
     * @return 【报价资质】-交易方式
     */
    public String getProcessTemplateCode() {
        return processTemplateCode;
    }

    /**
     * 设置【报价资质】-交易方式     *
     * 参数示例：<pre>accountPeriod</pre>     
     * 此参数必填
     */
    public void setProcessTemplateCode(String processTemplateCode) {
        this.processTemplateCode = processTemplateCode;
    }

    private String transToolType;

    /**
     * @return 【报价资质】-支付方式（1: 个人支付宝 2: 企业支付宝 3: 网商银行融易收（对公转账） 4:银行电子承兑汇票  5:银企付）多个支付方式用 ; 隔开
     */
    public String getTransToolType() {
        return transToolType;
    }

    /**
     * 设置【报价资质】-支付方式（1: 个人支付宝 2: 企业支付宝 3: 网商银行融易收（对公转账） 4:银行电子承兑汇票  5:银企付）多个支付方式用 ; 隔开     *
     * 参数示例：<pre>1;2</pre>     
     * 此参数必填
     */
    public void setTransToolType(String transToolType) {
        this.transToolType = transToolType;
    }

    private String[] supplierAreas;

    /**
     * @return 经营地址
     */
    public String[] getSupplierAreas() {
        return supplierAreas;
    }

    /**
     * 设置经营地址     *
     * 参数示例：<pre>[1531,4853]</pre>     
     * 此参数必填
     */
    public void setSupplierAreas(String[] supplierAreas) {
        this.supplierAreas = supplierAreas;
    }

    private String needSignAgreement;

    /**
     * @return 【询价方式及隐私】-是否需要签署保密协议(true/false)
     */
    public String getNeedSignAgreement() {
        return needSignAgreement;
    }

    /**
     * 设置【询价方式及隐私】-是否需要签署保密协议(true/false)     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setNeedSignAgreement(String needSignAgreement) {
        this.needSignAgreement = needSignAgreement;
    }

    private String subBizType;

    /**
     * @return 【采购要求】采购类型(singlepurchase:单次采购;priceprotocol:长期采购)
     */
    public String getSubBizType() {
        return subBizType;
    }

    /**
     * 设置【采购要求】采购类型(singlepurchase:单次采购;priceprotocol:长期采购)     *
     * 参数示例：<pre>singlepurchase</pre>     
     * 此参数必填
     */
    public void setSubBizType(String subBizType) {
        this.subBizType = subBizType;
    }

    private String sourceMethodType;

    /**
     * @return 【询价方式及隐私】-询价方式(open:对1688公开征集供应商 ; allmysupplier:邀请库内所有合格供应商报价 ; selectedmysupplier:定向邀请指定供应商报价)
     */
    public String getSourceMethodType() {
        return sourceMethodType;
    }

    /**
     * 设置【询价方式及隐私】-询价方式(open:对1688公开征集供应商 ; allmysupplier:邀请库内所有合格供应商报价 ; selectedmysupplier:定向邀请指定供应商报价)     *
     * 参数示例：<pre>open</pre>     
     * 此参数必填
     */
    public void setSourceMethodType(String sourceMethodType) {
        this.sourceMethodType = sourceMethodType;
    }

    private List supplierMemberIds;

    /**
     * @return 定向邀请指定的供应商(可以传多个，传供应商memberId)
     */
    public List getSupplierMemberIds() {
        return supplierMemberIds;
    }

    /**
     * 设置定向邀请指定的供应商(可以传多个，传供应商memberId)     *
     * 参数示例：<pre>["供应商memberId","供应商memberId"]</pre>     
     * 此参数必填
     */
    public void setSupplierMemberIds(List supplierMemberIds) {
        this.supplierMemberIds = supplierMemberIds;
    }

    private Date gmtProtocolStart;

    /**
     * @return 【采购要求】-价格有效期开始
     */
    public Date getGmtProtocolStart() {
        return gmtProtocolStart;
    }

    /**
     * 设置【采购要求】-价格有效期开始     *
     * 参数示例：<pre>20140801154220368+0800</pre>     
     * 此参数必填
     */
    public void setGmtProtocolStart(Date gmtProtocolStart) {
        this.gmtProtocolStart = gmtProtocolStart;
    }

    private Date gmtProtocolEnd;

    /**
     * @return 【采购要求】-价格有效期结束
     */
    public Date getGmtProtocolEnd() {
        return gmtProtocolEnd;
    }

    /**
     * 设置【采购要求】-价格有效期结束     *
     * 参数示例：<pre>20140801154220368+0800</pre>     
     * 此参数必填
     */
    public void setGmtProtocolEnd(Date gmtProtocolEnd) {
        this.gmtProtocolEnd = gmtProtocolEnd;
    }

    private String receiveStreetAddress;

    /**
     * @return 收货街道地址
     */
    public String getReceiveStreetAddress() {
        return receiveStreetAddress;
    }

    /**
     * 设置收货街道地址     *
     * 参数示例：<pre>长河街道</pre>     
     * 此参数必填
     */
    public void setReceiveStreetAddress(String receiveStreetAddress) {
        this.receiveStreetAddress = receiveStreetAddress;
    }

    private String onlineShoppingDesc;

    /**
     * @return 网购文件描述
     */
    public String getOnlineShoppingDesc() {
        return onlineShoppingDesc;
    }

    /**
     * 设置网购文件描述     *
     * 参数示例：<pre>XXX说明</pre>     
     * 此参数必填
     */
    public void setOnlineShoppingDesc(String onlineShoppingDesc) {
        this.onlineShoppingDesc = onlineShoppingDesc;
    }

    private List onlineShoppingAttachList;

    /**
     * @return 网购文件附件,附件id列表的id来源于上传附件的接口
     */
    public List getOnlineShoppingAttachList() {
        return onlineShoppingAttachList;
    }

    /**
     * 设置网购文件附件,附件id列表的id来源于上传附件的接口     *
     * 参数示例：<pre>[843860048803,843860029973]</pre>     
     * 此参数必填
     */
    public void setOnlineShoppingAttachList(List onlineShoppingAttachList) {
        this.onlineShoppingAttachList = onlineShoppingAttachList;
    }

    private Date gmtReceiveBeginDate;

    /**
     * @return 【采购要求】-期望收货开始时间
     */
    public Date getGmtReceiveBeginDate() {
        return gmtReceiveBeginDate;
    }

    /**
     * 设置【采购要求】-期望收货开始时间     *
     * 参数示例：<pre>20140801154220368+0800</pre>     
     * 此参数必填
     */
    public void setGmtReceiveBeginDate(Date gmtReceiveBeginDate) {
        this.gmtReceiveBeginDate = gmtReceiveBeginDate;
    }

    private Date gmtReceive;

    /**
     * @return 【采购要求】-期望收货结束日期
     */
    public Date getGmtReceive() {
        return gmtReceive;
    }

    /**
     * 设置【采购要求】-期望收货结束日期     *
     * 参数示例：<pre>20140801154220368+0800</pre>     
     * 此参数必填
     */
    public void setGmtReceive(Date gmtReceive) {
        this.gmtReceive = gmtReceive;
    }

    private List supplierLoginIds;

    /**
     * @return 供应商登录id集合
     */
    public List getSupplierLoginIds() {
        return supplierLoginIds;
    }

    /**
     * 设置供应商登录id集合     *
     * 参数示例：<pre>["登录id1","登录id2"]</pre>     
     * 此参数必填
     */
    public void setSupplierLoginIds(List supplierLoginIds) {
        this.supplierLoginIds = supplierLoginIds;
    }

    private String purchaseNoteType;

    /**
     * @return 【基础信息】-询价类型(1:现货/标准品；2:加工/定制品；3:库存/二手)默认1
     */
    public String getPurchaseNoteType() {
        return purchaseNoteType;
    }

    /**
     * 设置【基础信息】-询价类型(1:现货/标准品；2:加工/定制品；3:库存/二手)默认1     *
     * 参数示例：<pre>1</pre>     
     * 此参数必填
     */
    public void setPurchaseNoteType(String purchaseNoteType) {
        this.purchaseNoteType = purchaseNoteType;
    }

    private Integer deliveryPeriod;

    /**
     * @return 【采购要求】-交货期
     */
    public Integer getDeliveryPeriod() {
        return deliveryPeriod;
    }

    /**
     * 设置【采购要求】-交货期     *
     * 参数示例：<pre>5</pre>     
     * 此参数必填
     */
    public void setDeliveryPeriod(Integer deliveryPeriod) {
        this.deliveryPeriod = deliveryPeriod;
    }

    private String balanceDateType;

    /**
     * @return 【报价资质】-账期类型，账期结算日
     */
    public String getBalanceDateType() {
        return balanceDateType;
    }

    /**
     * 设置【报价资质】-账期类型，账期结算日     *
     * 参数示例：<pre>specify</pre>     
     * 此参数必填
     */
    public void setBalanceDateType(String balanceDateType) {
        this.balanceDateType = balanceDateType;
    }

    private String balanceDateValue;

    /**
     * @return 【报价资质】-结算日期或结算周期
     */
    public String getBalanceDateValue() {
        return balanceDateValue;
    }

    /**
     * 设置【报价资质】-结算日期或结算周期     *
     * 参数示例：<pre>20</pre>     
     * 此参数必填
     */
    public void setBalanceDateValue(String balanceDateValue) {
        this.balanceDateValue = balanceDateValue;
    }

    private Boolean allmysupplier;

    /**
     * @return 是否邀请所有合格供应商(true/false)
     */
    public Boolean getAllmysupplier() {
        return allmysupplier;
    }

    /**
     * 设置是否邀请所有合格供应商(true/false)     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setAllmysupplier(Boolean allmysupplier) {
        this.allmysupplier = allmysupplier;
    }

    private Boolean selectedmysupplier;

    /**
     * @return 是否指定供应商(true/false)
     */
    public Boolean getSelectedmysupplier() {
        return selectedmysupplier;
    }

    /**
     * 设置是否指定供应商(true/false)     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setSelectedmysupplier(Boolean selectedmysupplier) {
        this.selectedmysupplier = selectedmysupplier;
    }

    private Boolean openContact2All;

    /**
     * @return 是否公开联系方式(true/false)
     */
    public Boolean getOpenContact2All() {
        return openContact2All;
    }

    /**
     * 设置是否公开联系方式(true/false)     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setOpenContact2All(Boolean openContact2All) {
        this.openContact2All = openContact2All;
    }

    private Boolean needAudit4OpenContact;

    /**
     * @return 联系方式是否需要授权(true/false)
     */
    public Boolean getNeedAudit4OpenContact() {
        return needAudit4OpenContact;
    }

    /**
     * 设置联系方式是否需要授权(true/false)     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setNeedAudit4OpenContact(Boolean needAudit4OpenContact) {
        this.needAudit4OpenContact = needAudit4OpenContact;
    }

    private Boolean openContactBeforeQuote;

    /**
     * @return 报价前是否公开联系方式(true/false)
     */
    public Boolean getOpenContactBeforeQuote() {
        return openContactBeforeQuote;
    }

    /**
     * 设置报价前是否公开联系方式(true/false)     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setOpenContactBeforeQuote(Boolean openContactBeforeQuote) {
        this.openContactBeforeQuote = openContactBeforeQuote;
    }

    private String invoiceSubType;

    /**
     * @return 专票子类型  self：自行开票 ，agent： 税务代开
     */
    public String getInvoiceSubType() {
        return invoiceSubType;
    }

    /**
     * 设置专票子类型  self：自行开票 ，agent： 税务代开     *
     * 参数示例：<pre>self</pre>     
     * 此参数必填
     */
    public void setInvoiceSubType(String invoiceSubType) {
        this.invoiceSubType = invoiceSubType;
    }

    private Boolean supplierCanModifyQuantity;

    /**
     * @return 供应商报价可改数量(true/false)
     */
    public Boolean getSupplierCanModifyQuantity() {
        return supplierCanModifyQuantity;
    }

    /**
     * 设置供应商报价可改数量(true/false)     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setSupplierCanModifyQuantity(Boolean supplierCanModifyQuantity) {
        this.supplierCanModifyQuantity = supplierCanModifyQuantity;
    }

    private Boolean supplierCantModifyProtocalDate;

    /**
     * @return 是否开启供应商更改价格有效期的权限(true/false)
     */
    public Boolean getSupplierCantModifyProtocalDate() {
        return supplierCantModifyProtocalDate;
    }

    /**
     * 设置是否开启供应商更改价格有效期的权限(true/false)     *
     * 参数示例：<pre>false</pre>     
     * 此参数必填
     */
    public void setSupplierCantModifyProtocalDate(Boolean supplierCantModifyProtocalDate) {
        this.supplierCantModifyProtocalDate = supplierCantModifyProtocalDate;
    }

    private ComAlibabaCaigouCoopapiBuyofferParamExtraAttributes extraAttributes;

    /**
     * @return 询价单扩展信息
     */
    public ComAlibabaCaigouCoopapiBuyofferParamExtraAttributes getExtraAttributes() {
        return extraAttributes;
    }

    /**
     * 设置询价单扩展信息     *
     * 参数示例：<pre>{}</pre>     
     * 此参数必填
     */
    public void setExtraAttributes(ComAlibabaCaigouCoopapiBuyofferParamExtraAttributes extraAttributes) {
        this.extraAttributes = extraAttributes;
    }

    private ComAlibabaCaigouCoopapiBuyofferParamPurchaseItemWriteParam[] items;

    /**
     * @return 询价单清单。每个item项包括：subject(物料名称,String类型,不能为空，最大字符长度300), brandName(品牌,String类型,最大字符长度128), unit(单位,String类型,不能为空，最大字符长度10),purchaseAmount(采购数量,Long类型，不能为空)，productCode(物料,String类型，最大字符长度64)，prItemId（pr的item项目的行号，string类型，最大长度为64），desc（询价项目的描述，String类型，最大字符长度2000），attachmentIdList（附件id列表，附件的id来源于上传附件接口）
     */
    public ComAlibabaCaigouCoopapiBuyofferParamPurchaseItemWriteParam[] getItems() {
        return items;
    }

    /**
     * 设置询价单清单。每个item项包括：subject(物料名称,String类型,不能为空，最大字符长度300), brandName(品牌,String类型,最大字符长度128), unit(单位,String类型,不能为空，最大字符长度10),purchaseAmount(采购数量,Long类型，不能为空)，productCode(物料,String类型，最大字符长度64)，prItemId（pr的item项目的行号，string类型，最大长度为64），desc（询价项目的描述，String类型，最大字符长度2000），attachmentIdList（附件id列表，附件的id来源于上传附件接口）     *
     * 参数示例：<pre>{}</pre>     
     * 此参数必填
     */
    public void setItems(ComAlibabaCaigouCoopapiBuyofferParamPurchaseItemWriteParam[] items) {
        this.items = items;
    }

    private Long templateId;

    /**
     * @return 询价单模板id
     */
    public Long getTemplateId() {
        return templateId;
    }

    /**
     * 设置询价单模板id     *
     * 参数示例：<pre>11244</pre>     
     * 此参数必填
     */
    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

}
