package cn.alibaba.open.param;

import com.alibaba.ocean.rawsdk.client.APIId;
import com.alibaba.ocean.rawsdk.common.AbstractAPIRequest;

import java.util.*;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CaigouApiOrderPostOrderInfoParam extends AbstractAPIRequest<CaigouApiOrderPostOrderInfoResult> {

    public CaigouApiOrderPostOrderInfoParam() {
        super();
        oceanApiId = new APIId("cn.alibaba.open", "caigou.api.order.postOrderInfo", 1);
    }

    private String orderId;

    /**
     * @return 订单在接入商系统内的id，不可重复插入。
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * 设置订单在接入商系统内的id，不可重复插入。     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    private Long subUserId;

    /**
     * @return 操作员在1688上的子帐号ID，如果接入商有子账号，通过子账号来下单的，则这个参数必传；不传则系统会自动取主账号的userId作为默认值
     */
    public Long getSubUserId() {
        return subUserId;
    }

    /**
     * 设置操作员在1688上的子帐号ID，如果接入商有子账号，通过子账号来下单的，则这个参数必传；不传则系统会自动取主账号的userId作为默认值     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setSubUserId(Long subUserId) {
        this.subUserId = subUserId;
    }

    private String supplierMemberId;

    /**
     * @return 供应商在1688网站注册的memberId，supplierMemberId和supplierCode两者必须有一个不为空
     */
    public String getSupplierMemberId() {
        return supplierMemberId;
    }

    /**
     * 设置供应商在1688网站注册的memberId，supplierMemberId和supplierCode两者必须有一个不为空     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setSupplierMemberId(String supplierMemberId) {
        this.supplierMemberId = supplierMemberId;
    }

    private String supplierCode;

    /**
     * @return 供应商在采购商系统中的编号
     */
    public String getSupplierCode() {
        return supplierCode;
    }

    /**
     * 设置供应商在采购商系统中的编号     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    private String supplierCompanyName;

    /**
     * @return 供应商公司名
     */
    public String getSupplierCompanyName() {
        return supplierCompanyName;
    }

    /**
     * 设置供应商公司名     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setSupplierCompanyName(String supplierCompanyName) {
        this.supplierCompanyName = supplierCompanyName;
    }

    private String supplierMobile;

    /**
     * @return 供应商手机
     */
    public String getSupplierMobile() {
        return supplierMobile;
    }

    /**
     * 设置供应商手机     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setSupplierMobile(String supplierMobile) {
        this.supplierMobile = supplierMobile;
    }

    private String supplierEmail;

    /**
     * @return 供应商电子邮箱
     */
    public String getSupplierEmail() {
        return supplierEmail;
    }

    /**
     * 设置供应商电子邮箱     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setSupplierEmail(String supplierEmail) {
        this.supplierEmail = supplierEmail;
    }

    private Long totalAmount;

    /**
     * @return 订单的总金额：以分为单位的整数
     */
    public Long getTotalAmount() {
        return totalAmount;
    }

    /**
     * 设置订单的总金额：以分为单位的整数     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setTotalAmount(Long totalAmount) {
        this.totalAmount = totalAmount;
    }

    private Long freightAmount;

    /**
     * @return 运费总金额：以分为单位的整数
     */
    public Long getFreightAmount() {
        return freightAmount;
    }

    /**
     * 设置运费总金额：以分为单位的整数     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setFreightAmount(Long freightAmount) {
        this.freightAmount = freightAmount;
    }

    private Long orderAmount;

    /**
     * @return 货品总金额：以分为单位的整数
     */
    public Long getOrderAmount() {
        return orderAmount;
    }

    /**
     * 设置货品总金额：以分为单位的整数     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setOrderAmount(Long orderAmount) {
        this.orderAmount = orderAmount;
    }

    private String sourceType;

    /**
     * @return 来源类型：BUYOFFER：询价单；PRODUCT：采购目录
     */
    public String getSourceType() {
        return sourceType;
    }

    /**
     * 设置来源类型：BUYOFFER：询价单；PRODUCT：采购目录     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    private String orderStatus;

    /**
     * @return 订单状态默认为enabled，可设置类型为：disabled（无效）、enabled（有效）
     */
    public String getOrderStatus() {
        return orderStatus;
    }

    /**
     * 设置订单状态默认为enabled，可设置类型为：disabled（无效）、enabled（有效）     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    private String payStatus;

    /**
     * @return 支付状态，默认为unpaid，可设置状态为：unpaid（未支付），paid（已支付）
     */
    public String getPayStatus() {
        return payStatus;
    }

    /**
     * 设置支付状态，默认为unpaid，可设置状态为：unpaid（未支付），paid（已支付）     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setPayStatus(String payStatus) {
        this.payStatus = payStatus;
    }

    private String logisticsStatus;

    /**
     * @return 物流状态，默认为unshipped，可设置状态为：unshipped（未发货），shipped（已发货），received（已收货）
     */
    public String getLogisticsStatus() {
        return logisticsStatus;
    }

    /**
     * 设置物流状态，默认为unshipped，可设置状态为：unshipped（未发货），shipped（已发货），received（已收货）     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setLogisticsStatus(String logisticsStatus) {
        this.logisticsStatus = logisticsStatus;
    }

    private String failReason;

    /**
     * @return 若订单失败，则可以加上失败原因，长度小于等于300。
     */
    public String getFailReason() {
        return failReason;
    }

    /**
     * 设置若订单失败，则可以加上失败原因，长度小于等于300。     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setFailReason(String failReason) {
        this.failReason = failReason;
    }

    private String buyerCompanyName;

    /**
     * @return 买家公司名
     */
    public String getBuyerCompanyName() {
        return buyerCompanyName;
    }

    /**
     * 设置买家公司名     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setBuyerCompanyName(String buyerCompanyName) {
        this.buyerCompanyName = buyerCompanyName;
    }

    private String buyerMobile;

    /**
     * @return 买家电话
     */
    public String getBuyerMobile() {
        return buyerMobile;
    }

    /**
     * 设置买家电话     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setBuyerMobile(String buyerMobile) {
        this.buyerMobile = buyerMobile;
    }

    private String buyerEmail;

    /**
     * @return 买家email
     */
    public String getBuyerEmail() {
        return buyerEmail;
    }

    /**
     * 设置买家email     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setBuyerEmail(String buyerEmail) {
        this.buyerEmail = buyerEmail;
    }

    private List orderItemList;

    /**
     * @return 订单明细，为一个模型的json串的list，至少有一个。每个字段含义如下：orderItemId：String类型，订单item业务意义上主键，根据sourceType而定，若sourceType为BUYOFFER，则该值表示报价单item在1688平台上的id；若sourceType表示PRODUCT，则该值表示产品在1688平台上对应的价格编号productQuotationId，必填项；productName：产品的名称，必填项；price：产品单价，以分为单位的整数，必填项；count：产品数量，正整数，必填项；singleFreightAmount：运费，以分为单位的整数，非必填项；receiverPhone：收货人电话，非必填项；receiverMobile：收货人手机，非必填项；receiverPostCode：收货人邮编，非必填项；receiverAddress：收货人地址，非必填项；receiverName：收货人名称，非必填项；otherInfo：买家留言，补充信息，非必填项，字符长度小于500，将在供应商的采购单详情和发送给供应商的订单通知邮件中展示。
     */
    public List getOrderItemList() {
        return orderItemList;
    }

    /**
     * 设置订单明细，为一个模型的json串的list，至少有一个。每个字段含义如下：orderItemId：String类型，订单item业务意义上主键，根据sourceType而定，若sourceType为BUYOFFER，则该值表示报价单item在1688平台上的id；若sourceType表示PRODUCT，则该值表示产品在1688平台上对应的价格编号productQuotationId，必填项；productName：产品的名称，必填项；price：产品单价，以分为单位的整数，必填项；count：产品数量，正整数，必填项；singleFreightAmount：运费，以分为单位的整数，非必填项；receiverPhone：收货人电话，非必填项；receiverMobile：收货人手机，非必填项；receiverPostCode：收货人邮编，非必填项；receiverAddress：收货人地址，非必填项；receiverName：收货人名称，非必填项；otherInfo：买家留言，补充信息，非必填项，字符长度小于500，将在供应商的采购单详情和发送给供应商的订单通知邮件中展示。     *
     * 参数示例：<pre>[{"orderItemId":"111","productName":"电脑","price":"100","count":"10","singleFreightAmount":"100","receiverPhone":"13888888888","receiverMobile":"0516-666666","receiverPostCode":"222124","receiverAddress":"北京市","receiverName":"王小白","otherInfo":"合同下载链接：http://1688.com"},{"orderItemId":"222","productName":"电脑","price":"100","count":"10","singleFreightAmount":"100"}]</pre>     
     * 此参数必填
     */
    public void setOrderItemList(List orderItemList) {
        this.orderItemList = orderItemList;
    }

    private String payType;

    /**
     * @return 订单支付类型， online--线上支付，即用支付宝支付，目前暂不支持线上支付类型；offline--线下支付
     */
    public String getPayType() {
        return payType;
    }

    /**
     * 设置订单支付类型， online--线上支付，即用支付宝支付，目前暂不支持线上支付类型；offline--线下支付     *
     * 参数示例：<pre>offline</pre>     
     * 此参数必填
     */
    public void setPayType(String payType) {
        this.payType = payType;
    }

}
