package cn.alibaba.open.param;

import com.alibaba.ocean.rawsdk.client.APIId;
import com.alibaba.ocean.rawsdk.common.AbstractAPIRequest;

import java.util.*;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ComAlibabaProcurementBuyerReceiveGoodsServiceCreateReceiveGoodsNoteParam extends
        AbstractAPIRequest<ComAlibabaProcurementBuyerReceiveGoodsServiceCreateReceiveGoodsNoteResult> {

    public ComAlibabaProcurementBuyerReceiveGoodsServiceCreateReceiveGoodsNoteParam() {
        super();
        oceanApiId = new APIId("cn.alibaba.open", "com.alibaba.procurement.BuyerReceiveGoodsService.createReceiveGoodsNote", 1);
    }

    private String buyerInsideRemark;

    /**
     * @return 买家对内备注	
     */
    public String getBuyerInsideRemark() {
        return buyerInsideRemark;
    }

    /**
     * 设置买家对内备注	     *
     * 参数示例：<pre>给自己内部看的备注</pre>     
     * 此参数必填
     */
    public void setBuyerInsideRemark(String buyerInsideRemark) {
        this.buyerInsideRemark = buyerInsideRemark;
    }

    private String buyerOutsideRemark;

    /**
     * @return 买家对外备注	
     */
    public String getBuyerOutsideRemark() {
        return buyerOutsideRemark;
    }

    /**
     * 设置买家对外备注	     *
     * 参数示例：<pre>给卖家看的备注</pre>     
     * 此参数必填
     */
    public void setBuyerOutsideRemark(String buyerOutsideRemark) {
        this.buyerOutsideRemark = buyerOutsideRemark;
    }

    private AlibabaProcurementApiReceivegoodsIntegrationParamCreateReceiveGoodsNoteEntryParam[] createReceiveGoodsNoteEntryParams;

    /**
     * @return 创建收货子单入参列表	
     */
    public AlibabaProcurementApiReceivegoodsIntegrationParamCreateReceiveGoodsNoteEntryParam[] getCreateReceiveGoodsNoteEntryParams() {
        return createReceiveGoodsNoteEntryParams;
    }

    /**
     * 设置创建收货子单入参列表	     *
     * 参数示例：<pre></pre>     
     * 此参数必填
     */
    public void setCreateReceiveGoodsNoteEntryParams(
            AlibabaProcurementApiReceivegoodsIntegrationParamCreateReceiveGoodsNoteEntryParam[] createReceiveGoodsNoteEntryParams) {
        this.createReceiveGoodsNoteEntryParams = createReceiveGoodsNoteEntryParams;
    }

    private Date receiveDate;

    /**
     * @return 收货日期
     */
    public Date getReceiveDate() {
        return receiveDate;
    }

    /**
     * 设置收货日期     *
     * 参数示例：<pre>20190917110700565+0800</pre>     
     * 此参数必填
     */
    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }

    private String type;

    /**
     * @return 类型有两个值：send_goods_entry（基于发货子单）； order_entry（基于采购子订单）
     */
    public String getType() {
        return type;
    }

    /**
     * 设置类型有两个值：send_goods_entry（基于发货子单）； order_entry（基于采购子订单）     *
     * 参数示例：<pre>order_entry</pre>     
     * 此参数必填
     */
    public void setType(String type) {
        this.type = type;
    }

    private String subUserLoginId;

    /**
     * @return 子账号LoginId
     */
    public String getSubUserLoginId() {
        return subUserLoginId;
    }

    /**
     * 设置子账号LoginId     *
     * 参数示例：<pre>阿里:张三</pre>     
     * 此参数必填
     */
    public void setSubUserLoginId(String subUserLoginId) {
        this.subUserLoginId = subUserLoginId;
    }

    private Boolean allowSupplierCreateSettlementNote;

    /**
     * @return 是否允许供应商创建结算单(true/false)，默认false，注意需提前开启carbon配置
     */
    public Boolean getAllowSupplierCreateSettlementNote() {
        return allowSupplierCreateSettlementNote;
    }

    /**
     * 设置是否允许供应商创建结算单(true/false)，默认false，注意需提前开启carbon配置     *
     * 参数示例：<pre>true</pre>     
     * 此参数必填
     */
    public void setAllowSupplierCreateSettlementNote(Boolean allowSupplierCreateSettlementNote) {
        this.allowSupplierCreateSettlementNote = allowSupplierCreateSettlementNote;
    }

}
