package cn.alibaba.open.param;

import com.alibaba.ocean.rawsdk.client.APIId;
import com.alibaba.ocean.rawsdk.common.AbstractAPIRequest;

import java.util.*;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ComAlibabaProcurementBuyerReturnGoodsServiceCreateReturnGoodsNoteParam extends
        AbstractAPIRequest<ComAlibabaProcurementBuyerReturnGoodsServiceCreateReturnGoodsNoteResult> {

    public ComAlibabaProcurementBuyerReturnGoodsServiceCreateReturnGoodsNoteParam() {
        super();
        oceanApiId = new APIId("cn.alibaba.open", "com.alibaba.procurement.BuyerReturnGoodsService.createReturnGoodsNote", 1);
    }

    private String buyerInsideRemark;

    /**
     * @return 买家对内备注	
     */
    public String getBuyerInsideRemark() {
        return buyerInsideRemark;
    }

    /**
     * 设置买家对内备注	     *
     * 参数示例：<pre>给自己内部看的备注</pre>     
     * 此参数必填
     */
    public void setBuyerInsideRemark(String buyerInsideRemark) {
        this.buyerInsideRemark = buyerInsideRemark;
    }

    private String buyerOutsideRemark;

    /**
     * @return 买家对外备注	
     */
    public String getBuyerOutsideRemark() {
        return buyerOutsideRemark;
    }

    /**
     * 设置买家对外备注	     *
     * 参数示例：<pre>给卖家看的备注</pre>     
     * 此参数必填
     */
    public void setBuyerOutsideRemark(String buyerOutsideRemark) {
        this.buyerOutsideRemark = buyerOutsideRemark;
    }

    private AlibabaProcurementApiReturngoodsIntegrationParamCreateReturnGoodsNoteEntryParam[] createReturnGoodsNoteEntryParams;

    /**
     * @return 创建退货子单入参列表	
     */
    public AlibabaProcurementApiReturngoodsIntegrationParamCreateReturnGoodsNoteEntryParam[] getCreateReturnGoodsNoteEntryParams() {
        return createReturnGoodsNoteEntryParams;
    }

    /**
     * 设置创建退货子单入参列表	     *
     * 参数示例：<pre>null</pre>     
     * 此参数必填
     */
    public void setCreateReturnGoodsNoteEntryParams(
            AlibabaProcurementApiReturngoodsIntegrationParamCreateReturnGoodsNoteEntryParam[] createReturnGoodsNoteEntryParams) {
        this.createReturnGoodsNoteEntryParams = createReturnGoodsNoteEntryParams;
    }

    private String returnDate;

    /**
     * @return 退货日期	
     */
    public String getReturnDate() {
        return returnDate;
    }

    /**
     * 设置退货日期	     *
     * 参数示例：<pre>2018-10-01</pre>     
     * 此参数必填
     */
    public void setReturnDate(String returnDate) {
        this.returnDate = returnDate;
    }

    private String type;

    /**
     * @return 退货类型，基于子订单传:order_entry；基于子收货单传:receive_goods_entry，默认为:order_entry
     */
    public String getType() {
        return type;
    }

    /**
     * 设置退货类型，基于子订单传:order_entry；基于子收货单传:receive_goods_entry，默认为:order_entry     *
     * 参数示例：<pre>order_entry</pre>     
     * 此参数必填
     */
    public void setType(String type) {
        this.type = type;
    }

}
