package cn.alibaba.open.param;

import java.util.*;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CompanyCredit {

    private String authType;

    /**
     * @return 认证类型
     */
    public String getAuthType() {
        return authType;
    }

    /**
     * 设置认证类型     *
     * 参数示例：<pre>返回结果:枚举:ov 或 av 或 cna 或 pna 返回其中一个.
    认证类型的名称:
    ov:实地认证;
    av:诚信通av认证;
    cna:企业实名认证;
    pna:个人实名认证;
    一个用户可能具有多个资质.当有个多个资质时.返回优先级为
    (实地>AV>公司实名>个人实名)</pre>     
     * 此参数必填
     */
    public void setAuthType(String authType) {
        this.authType = authType;
    }

    private Long supplierLevel;

    /**
     * @return 阿里巴巴供应商等级
     */
    public Long getSupplierLevel() {
        return supplierLevel;
    }

    /**
     * 设置阿里巴巴供应商等级     *
     * 参数示例：<pre>1星=1;
    2星=2;
    3星=3;
    4星=4;
    5星=5;
    1钻=6;
    2钻=7;
    3钻=8;
    4钻=9;
    5钻=10;
    1冠=11;
    2冠=12;
    3冠=13;
    4冠=14;
    5冠=15;</pre>     
     * 此参数必填
     */
    public void setSupplierLevel(Long supplierLevel) {
        this.supplierLevel = supplierLevel;
    }

    private Long truthfulDescription;

    /**
     * @return 描述相符
     */
    public Long getTruthfulDescription() {
        return truthfulDescription;
    }

    /**
     * 设置描述相符     *
     * 参数示例：<pre>返回结果范围0-50.分数越高越好</pre>     
     * 此参数必填
     */
    public void setTruthfulDescription(Long truthfulDescription) {
        this.truthfulDescription = truthfulDescription;
    }

    private Long serviceAttitude;

    /**
     * @return 服务态度
     */
    public Long getServiceAttitude() {
        return serviceAttitude;
    }

    /**
     * 设置服务态度     *
     * 参数示例：<pre>返回结果范围0-50.分数越高越好</pre>     
     * 此参数必填
     */
    public void setServiceAttitude(Long serviceAttitude) {
        this.serviceAttitude = serviceAttitude;
    }

    private Long arrivalRate;

    /**
     * @return 到货速度
     */
    public Long getArrivalRate() {
        return arrivalRate;
    }

    /**
     * 设置到货速度     *
     * 参数示例：<pre>返回结果范围0-50.分数越高越好</pre>     
     * 此参数必填
     */
    public void setArrivalRate(Long arrivalRate) {
        this.arrivalRate = arrivalRate;
    }

    private Long buyersCommentsIn180days;

    /**
     * @return 180天买家评论
     */
    public Long getBuyersCommentsIn180days() {
        return buyersCommentsIn180days;
    }

    /**
     * 设置180天买家评论     *
     * 参数示例：<pre>返回结果范围0-100.标识0~100的百分比.比率越高越好</pre>     
     * 此参数必填
     */
    public void setBuyersCommentsIn180days(Long buyersCommentsIn180days) {
        this.buyersCommentsIn180days = buyersCommentsIn180days;
    }

    private Long averageDeliverySpeedIn90days;

    /**
     * @return 90天平均发货速度
     */
    public Long getAverageDeliverySpeedIn90days() {
        return averageDeliverySpeedIn90days;
    }

    /**
     * 设置90天平均发货速度     *
     * 参数示例：<pre>返回结果范围0-100.标识0~100的百分比.比率越高越好</pre>     
     * 此参数必填
     */
    public void setAverageDeliverySpeedIn90days(Long averageDeliverySpeedIn90days) {
        this.averageDeliverySpeedIn90days = averageDeliverySpeedIn90days;
    }

    private Long refundRateIn90days;

    /**
     * @return 90天退款率
     */
    public Long getRefundRateIn90days() {
        return refundRateIn90days;
    }

    /**
     * 设置90天退款率     *
     * 参数示例：<pre>返回结果范围0-100.标识0~100的百分比.比率越高越好</pre>     
     * 此参数必填
     */
    public void setRefundRateIn90days(Long refundRateIn90days) {
        this.refundRateIn90days = refundRateIn90days;
    }

    private Long complaintRateIn90days;

    /**
     * @return 90天投诉率
     */
    public Long getComplaintRateIn90days() {
        return complaintRateIn90days;
    }

    /**
     * 设置90天投诉率     *
     * 参数示例：<pre>返回结果范围0-100.标识0~100的百分比.比率越高越好</pre>     
     * 此参数必填
     */
    public void setComplaintRateIn90days(Long complaintRateIn90days) {
        this.complaintRateIn90days = complaintRateIn90days;
    }

}
