package cn.alibaba.open.param;

import java.util.*;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SupplierDetail {

    private String loginId;

    /**
     * @return 供应商登录名
     */
    public String getLoginId() {
        return loginId;
    }

    /**
     * 设置供应商登录名     *
     * 参数示例：<pre>8989ad</pre>     
     * 此参数必填
     */
    public void setLoginId(String loginId) {
        this.loginId = loginId;
    }

    private String companyRegNo;

    /**
     * @return 社会信用代码
     */
    public String getCompanyRegNo() {
        return companyRegNo;
    }

    /**
     * 设置社会信用代码     *
     * 参数示例：<pre>5432</pre>     
     * 此参数必填
     */
    public void setCompanyRegNo(String companyRegNo) {
        this.companyRegNo = companyRegNo;
    }

    private CertificationTypes certifications;

    /**
     * @return 供应商资质证书 {	key包含:businessLicence;taxRegistration;taxRegistrationBackUp;OrganizationCode;approvalOfForeignInvestmentEnterprises;icpLicence;productLicence;otherLicence;value 为List<供应商资质证书>类型:List的泛型请参见 domain:供应商资质证书key的名字解释.	营业执照 : businessLicence;	税务登记证 : taxRegistration;	税务登记证副本 : taxRegistrationBackUp;	组织结构代码证 : OrganizationCode;	外商投资企业批准证书 : approvalOfForeignInvestmentEnterprises;	经营许可类证书列表（支持多个）: icpLicence;	产品类证书列表（支持多个）:	productLicence;	其他类证书列表（支持多个）:	otherLicence;}
     */
    public CertificationTypes getCertifications() {
        return certifications;
    }

    /**
     * 设置供应商资质证书 {	key包含:businessLicence;taxRegistration;taxRegistrationBackUp;OrganizationCode;approvalOfForeignInvestmentEnterprises;icpLicence;productLicence;otherLicence;value 为List<供应商资质证书>类型:List的泛型请参见 domain:供应商资质证书key的名字解释.	营业执照 : businessLicence;	税务登记证 : taxRegistration;	税务登记证副本 : taxRegistrationBackUp;	组织结构代码证 : OrganizationCode;	外商投资企业批准证书 : approvalOfForeignInvestmentEnterprises;	经营许可类证书列表（支持多个）: icpLicence;	产品类证书列表（支持多个）:	productLicence;	其他类证书列表（支持多个）:	otherLicence;}     *
     * 参数示例：<pre>{             "businessLicence":[                 {                     "expiryDate":"",                     "code":"1111",                     "certificatePicture":[                         "img/ibank/2019/181/774/12407477181.jpg"                     ],                     "certifyingAuthority":"12121234",                     "certificateName":"营业执照",                     "effectiveDate":"2019-10-08 00:00:00"                 }             ],             "productLicence":[                 {                     "expiryDate":"",                     "code":"asdasdasd",                     "certificatePicture":[                         "img/ibank/2016/462/364/3489463264.jpg"                     ],                     "certifyingAuthority":"sadasdasd",                     "certificateName":"实用新型专利证书或实用新型专利证书授权书",                     "effectiveDate":"2016-09-07 00:00:00"                 }             ],             "taxRegistrationBackUp":[                 {                     "expiryDate":"",                     "code":"123456678786785",                     "certificatePicture":[                         "img/ibank/2019/181/738/11358837181.jpg"                     ],                     "certifyingAuthority":"税务局",                     "certificateName":"一般纳税人证明材料",                     "effectiveDate":"2019-04-16 00:00:00"                 }             ],             "otherLicence":[                 {                     "expiryDate":"",                     "code":"1231231",                     "certificatePicture":[                         "img/ibank/2018/797/310/9111013797.jpg"                     ],                     "certifyingAuthority":"1231231",                     "certificateName":"其他",                     "effectiveDate":"2018-07-12 00:00:00"                 }             ]         }</pre>     
     * 此参数必填
     */
    public void setCertifications(CertificationTypes certifications) {
        this.certifications = certifications;
    }

    private ContactInfo contactInfo;

    /**
     * @return 供应商联系方式{    姓名;    手机;    性别;    电话;}
     */
    public ContactInfo getContactInfo() {
        return contactInfo;
    }

    /**
     * 设置供应商联系方式{    姓名;    手机;    性别;    电话;}     *
     * 参数示例：<pre>{             "gender":"M",             "phone":"86-0571-81895955",             "name":"乔的石",             "mobile":"17607097705",             "contactAddress":"中国-黄石-黄石市黄石港区-汉正街",             "fax":"86-0571-81895956"         }</pre>     
     * 此参数必填
     */
    public void setContactInfo(ContactInfo contactInfo) {
        this.contactInfo = contactInfo;
    }

    private CompanyCredit companyCredit;

    /**
     * @return 供应商公司信用{    认证类型;    供应等级;    描述相符;    服务态度;    到货速度;    180天买家评论;    90天平均发货速度;    90天退款率;    90天投诉率;}
     */
    public CompanyCredit getCompanyCredit() {
        return companyCredit;
    }

    /**
     * 设置供应商公司信用{    认证类型;    供应等级;    描述相符;    服务态度;    到货速度;    180天买家评论;    90天平均发货速度;    90天退款率;    90天投诉率;}     *
     * 参数示例：<pre>{             "truthfulDescription":50,             "serviceAttitude":30,             "buyersCommentsIn180days":0,             "complaintRateIn90days":0,             "refundRateIn90days":0,             "arrivalRate":30,             "supplierLevel":2,             "averageDeliverySpeedIn90days":0,             "authType":"cna"         }</pre>     
     * 此参数必填
     */
    public void setCompanyCredit(CompanyCredit companyCredit) {
        this.companyCredit = companyCredit;
    }

    private BusinessAbility businessAbility;

    /**
     * @return 供应商经营能力{    员工人数;    90天累计成交笔数;    为名企供过货;    支持买家保障;    支持增值税发票;    支持支付宝;    支付宝类型;    为淘宝卖家供过货;    90天累计成交买家数}
     */
    public BusinessAbility getBusinessAbility() {
        return businessAbility;
    }

    /**
     * 设置供应商经营能力{    员工人数;    90天累计成交笔数;    为名企供过货;    支持买家保障;    支持增值税发票;    支持支付宝;    支付宝类型;    为淘宝卖家供过货;    90天累计成交买家数}     *
     * 参数示例：<pre>{             "buyerProtected":true,             "employeesCount":"5 人以下",             "hasTaobaoSeller":false,             "strokeBuyerCount90days":0,             "hasMingQiBuyer":true,             "bindAlipay":true,             "vatInvoice":true,             "strokeCountIn90days":0,             "alipayType":"个人支付宝"         }{             "buyerProtected":true,             "employeesCount":"5 人以下",             "hasTaobaoSeller":false,             "strokeBuyerCount90days":0,             "hasMingQiBuyer":true,             "bindAlipay":true,             "vatInvoice":true,             "strokeCountIn90days":0,             "alipa{             "buyerProtected":true,             "employeesCount":"5 人以下",             "hasTaobaoSeller":false,             "strokeBuyerCount90days":0,             "hasMingQiBuyer":true,             "bindAlipay":true,             "vatInvoice":true,             "strokeCountIn90days":0,             "alipayType":"个人支付宝"         }yType":"个人支付宝"         }</pre>     
     * 此参数必填
     */
    public void setBusinessAbility(BusinessAbility businessAbility) {
        this.businessAbility = businessAbility;
    }

    private BusinessInfo businessInfo;

    /**
     * @return 供应商经营信息{    经营模式;    主营行业;    主营产品/服务;    品牌名称;    经营地址}
     */
    public BusinessInfo getBusinessInfo() {
        return businessInfo;
    }

    /**
     * 设置供应商经营信息{    经营模式;    主营行业;    主营产品/服务;    品牌名称;    经营地址}     *
     * 参数示例：<pre>{             "brandName":"sadhk",             "productionService":[                 "测试字段",                 "建国大业",                 "毛主席"             ],             "mainIndustries":"二极管、五金包装、电池包装、白炽灯、包装用纸、首饰包装",             "businessModel":"生产加工",             "businessAddress":"湖北 武汉市硚口区",             "enterpriseType":"外资企业"         }</pre>     
     * 此参数必填
     */
    public void setBusinessInfo(BusinessInfo businessInfo) {
        this.businessInfo = businessInfo;
    }

    private CompanyInfo companyInfo;

    /**
     * @return 供应商公司信息{	诚信通会员标识;	政府邀约供应商标识;	工商注册信息{		公司名字;		法定代表人/负责人;		公司注册地址;		工商注册号;		公司类型;		成立日期;		注册资本;		登记机关;		营业期限;		经营范围	}}
     */
    public CompanyInfo getCompanyInfo() {
        return companyInfo;
    }

    /**
     * 设置供应商公司信息{	诚信通会员标识;	政府邀约供应商标识;	工商注册信息{		公司名字;		法定代表人/负责人;		公司注册地址;		工商注册号;		公司类型;		成立日期;		注册资本;		登记机关;		营业期限;		经营范围	}}     *
     * 参数示例：<pre>{             "icrInfo":{                 "bankAccount":"撒旦教",                 "principal":"陈文",                 "bank":"招商银行",                 "companyAddress":"中国 江苏 苏州",                 "registrationId":"91320505782061093N",                 "dateOfEstablishment":"2005",                 "name":"阿里巴巴(中国)网络技术有限公司苏州分公司",                 "enterpriseType":"外资企业"             },             "homepageUrl":[                 "https://muyipeixinbaolin.1688.com/"             ],             "companySummary":"阿里巴巴网络有限公司主营324234231等。\r\n公司秉承“顾客至上，锐意进取”的经营理念，\r\n坚持“客户第一”的原则为广大客户提供优质的服务。\r\n欢迎惠顾！谢谢12312ccccg201000\r\n  阿里巴巴网络有限公司主营324234231等。\r\n公司秉承“顾客至上，锐意进取”的经营理念，\r\n  坚持“客户第一”的原则为广大客户提供优质的服务。dsf\r\n欢迎惠顾！谢谢123qrewsdgdhd 毛主席  建国大业\r\n习测试sfddgds\r\n测试、、、wetry",             "governmentInvitedSupplier":false,             "tp":false         }</pre>     
     * 此参数必填
     */
    public void setCompanyInfo(CompanyInfo companyInfo) {
        this.companyInfo = companyInfo;
    }

    private String outCode;

    /**
     * @return 买家给供应商设置的外部编码
     */
    public String getOutCode() {
        return outCode;
    }

    /**
     * 设置买家给供应商设置的外部编码     *
     * 参数示例：<pre>112</pre>     
     * 此参数必填
     */
    public void setOutCode(String outCode) {
        this.outCode = outCode;
    }

}
