/**
 * 
 */
package com.alibaba.ocean.rawsdk.client.http.platform;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

import com.alibaba.ocean.rawsdk.client.Response;
import com.alibaba.ocean.rawsdk.client.http.AbstractHttpClient;
import com.alibaba.ocean.rawsdk.client.http.HttpResponseBuilder;
import com.alibaba.ocean.rawsdk.client.http.HttpSupport;
import com.alibaba.ocean.rawsdk.client.http.InvokeContext;
import com.alibaba.ocean.rawsdk.client.policy.ClientPolicy;
import com.alibaba.ocean.rawsdk.client.policy.RequestPolicy;
import com.alibaba.ocean.rawsdk.client.serialize.DeSerializerListener;
import com.alibaba.ocean.rawsdk.client.serialize.SerializerProvider;

/**
 * @author hongbang.hb
 *
 */
public class HttpURLConnectionClient extends AbstractHttpClient {

	public HttpURLConnectionClient(SerializerProvider serializerProvider, HttpResponseBuilder responseBuilder) {
		super(serializerProvider, responseBuilder);
	}

	@Override
	protected Response doMultipartPost(URL url, Map<String, Object> parameters, InvokeContext invokeContext,
			ClientPolicy clientPolicy, Collection<DeSerializerListener> deSerializerListners) throws IOException {
		HttpURLConnection conn = null;
		Response response = null;
		String BOUNDARY = "---------------------------123821742118716";
		OutputStream out = null;
		try {
			conn = (HttpURLConnection) url.openConnection();
			conn.setRequestMethod("POST");
			conn.setDoInput(true);
			conn.setDoOutput(true);
			conn.setConnectTimeout(getConnectTimeout(clientPolicy, invokeContext.getPolicy()));
			conn.setReadTimeout(getReadTimeout(clientPolicy, invokeContext.getPolicy()));
			Map<String, String> clientHttpHeader = HttpSupport.buildHttpHeader(invokeContext, clientPolicy);
			for (Map.Entry<String, String> entry : clientHttpHeader.entrySet()) {
				conn.setRequestProperty(entry.getKey(), entry.getValue());
			}
			conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);

			out = new DataOutputStream(conn.getOutputStream());

			StringBuffer strBuf = new StringBuffer();
			Iterator<Map.Entry<String, Object>> iter = parameters.entrySet().iterator();
			while (iter.hasNext()) {
				Map.Entry<String, Object> entry = iter.next();
				String inputName = (String) entry.getKey();
				Object inputValue = entry.getValue();
				if (inputValue == null) {
					continue;
				}
				if (inputValue.getClass().isAssignableFrom(byte[].class)
						|| inputValue.getClass().isAssignableFrom(Byte[].class)) {
					strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
					strBuf.append("Content-Disposition: form-data; name=\"" + inputName + "\"" + "\"\r\n");
					strBuf.append("Content-Type:" + "application/x-www-form-urlencoded" + "\r\n\r\n");
					out.write(strBuf.toString().getBytes());
					if (inputValue instanceof byte[]) {
						byte[] inputBytes = (byte[]) inputValue;
						out.write(inputBytes);
					}
					if (inputValue instanceof Byte[]) {
						Byte[] inputBytes = (Byte[]) inputValue;
						for (Byte b : inputBytes) {
							out.write(b.byteValue());
						}
					}
				} else {
					strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
					strBuf.append("Content-Disposition: form-data; name=\"" + inputName + "\"\r\n\r\n");
					strBuf.append(inputValue);
					out.write(strBuf.toString().getBytes());
				}
			}
			int httpCode = conn.getResponseCode();
			String contentEncoding = conn.getContentEncoding();
			String contentType = conn.getContentType();
			String requestId=conn.getHeaderField("RequestId");
			String traceId=conn.getHeaderField("EagleEye-TraceId");
			InputStream inputStream = null;
			if (httpCode >= 200 && httpCode <= 299) {
				inputStream = conn.getInputStream();
			} else {
				inputStream = conn.getErrorStream();
			}
			response = this.getResponseBuilder().buildResponse(inputStream, httpCode, contentEncoding, contentType,
					invokeContext, deSerializerListners);
			response.setRequestId(requestId);
			response.setTraceId(traceId);
		} catch (IOException e) {
			throw e;
		} finally {
			if (out != null) {
				out.close();
			}
			if (conn != null) {
				conn.disconnect();
			}
		}
		return response;
	}

	private int getConnectTimeout(ClientPolicy clientPolicy, RequestPolicy policy) {
		if (policy.getConnectTimeout() > 0) {
            return policy.getConnectTimeout();
        }
		return clientPolicy.getConnectTimeout();
	}

	private int getReadTimeout(ClientPolicy clientPolicy, RequestPolicy policy) {
		if (policy.getTimeout() > 0) {
            return policy.getTimeout();
        }
		return clientPolicy.getTimeout();
	}

	@Override
	protected Response doPost(URL url, Map<String, Object> parameters, InvokeContext invokeContext,
			ClientPolicy clientPolicy, Collection<DeSerializerListener> deSerializerListners) throws IOException {
		HttpURLConnection conn = null;
		OutputStream out = null;
		Response response = null;
		try {
			try {
				Proxy proxy = clientPolicy.getProxy();
				if (proxy != null) {
					conn = (HttpURLConnection) url.openConnection(proxy);
				} else {
					conn = (HttpURLConnection) url.openConnection();
				}
				conn.setRequestMethod("POST");
				conn.setDoInput(true);
				conn.setDoOutput(true);
				conn.setConnectTimeout(getConnectTimeout(clientPolicy, invokeContext.getPolicy()));
				conn.setReadTimeout(getReadTimeout(clientPolicy, invokeContext.getPolicy()));
				Map<String, String> clientHttpHeader = HttpSupport.buildHttpHeader(invokeContext, clientPolicy);
				for (Map.Entry<String, String> entry : clientHttpHeader.entrySet()) {
					conn.setRequestProperty(entry.getKey(), entry.getValue());
				}
			} catch (IOException e) {
				throw e;
			}
			try {
				String query = HttpSupport.buildQuery(parameters);
				byte[] content = {};
				if (query != null) {
					content = query.getBytes(invokeContext.getPolicy().getContentCharset());
				}
				out = conn.getOutputStream();
				out.write(content);

				int httpCode = conn.getResponseCode();
				String contentEncoding = conn.getContentEncoding();
				String contentType = conn.getContentType();
				String requestId=conn.getHeaderField("RequestId");
				String traceId=conn.getHeaderField("EagleEye-TraceId");
				InputStream inputStream = null;
				if (httpCode >= 200 && httpCode <= 299) {
					inputStream = conn.getInputStream();
				} else {
					inputStream = conn.getErrorStream();
				}

				response = this.getResponseBuilder().buildResponse(inputStream, httpCode, contentEncoding, contentType,
						invokeContext, deSerializerListners);
				response.setRequestId(requestId);
				response.setTraceId(traceId);
			} catch (IOException e) {
				throw e;
			}
		} finally {
			if (out != null) {
				out.close();
			}
			if (conn != null) {
				conn.disconnect();
			}
		}
		return response;
	}

	@Override
	protected Response doGet(URL url, Map<String, Object> parameters,InvokeContext invokeContext,
			ClientPolicy clientPolicy, Collection<DeSerializerListener> deSerializerListners) throws IOException {
		HttpURLConnection conn = null;
		OutputStream out = null;
		Response response = null;
		try {
			try {
				Proxy proxy = clientPolicy.getProxy();
				if (proxy != null) {
					conn = (HttpURLConnection) url.openConnection(proxy);
				} else {
					conn = (HttpURLConnection) url.openConnection();
				}
				conn.setRequestMethod("GET");
				conn.setDoInput(true);
				conn.setDoOutput(true);
				conn.setConnectTimeout(getConnectTimeout(clientPolicy, invokeContext.getPolicy()));
				conn.setReadTimeout(getReadTimeout(clientPolicy, invokeContext.getPolicy()));
				Map<String, String> clientHttpHeader = HttpSupport.buildHttpHeader(invokeContext, clientPolicy);
				for (Map.Entry<String, String> entry : clientHttpHeader.entrySet()) {
					conn.setRequestProperty(entry.getKey(), entry.getValue());
				}
			} catch (IOException e) {
				throw e;
			}
			try {
				int httpCode = conn.getResponseCode();
				String contentEncoding = conn.getContentEncoding();
				String contentType = conn.getContentType();
				String requestId=conn.getHeaderField("RequestId");
				String traceId=conn.getHeaderField("EagleEye-TraceId");
				InputStream inputStream = null;
				if (httpCode >= 200 && httpCode <= 299) {
					inputStream = conn.getInputStream();
				} else {
					inputStream = conn.getErrorStream();
				}

				response = this.getResponseBuilder().buildResponse(inputStream, httpCode, contentEncoding, contentType,
						invokeContext, deSerializerListners);
				response.setRequestId(requestId);
				response.setTraceId(traceId);
			} catch (IOException e) {
				throw e;
			}
		} finally {
			if (out != null) {
				out.close();
			}
			if (conn != null) {
				conn.disconnect();
			}
		}
		return response;
	}

}
