/**
 * Project: ocean.client.java.basic
 *
 * File Created at 2011-10-27
 * $Id: Json2HttpResponseParser.java 311300 2013-12-23 06:15:28Z yichun.wangyc $
 *
 * Copyright 2008 Alibaba.com Croporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Alibaba Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Alibaba.com.
 */
package com.alibaba.ocean.rawsdk.client.imp.serialize;

import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.ocean.rawsdk.client.policy.Protocol;
import com.alibaba.ocean.rawsdk.client.serialize.DeSerializerListener;
import com.alibaba.ocean.rawsdk.client.util.ExceptionParser;

/**
 * 专门处理oauth请求结果的反序列化类
 *
 * @author duferial
 *
 */
public class Oauth2Deserializer extends Json2Deserializer {

	@Override
	public String supportedContentType() {
		return Protocol.oauth2.name();
	}

	@Override
	public Throwable buildException(String content, int statusCode) {
		for (DeSerializerListener deSerializerListener : listenerMap.values()) {
			deSerializerListener.onResponseExceptioned(content);
		}
		Map result = JSON.parseObject(content, Map.class);
		return ExceptionParser.buildException4OAuth2(result);
	}

}
