package com.alibaba.ocean.rawsdk.client.util;

import java.io.IOException;
import java.util.Map;

import com.alibaba.ocean.rawsdk.client.exception.OceanException;
import com.alibaba.ocean.rawsdk.util.GenericsUtil;

/**
 * Build <code>Exception</code> for all kinds of
 * {@link com.alibaba.ocean.rawsdk.client.policy.Protocol}, base on the exption
 * string which got from <code>Reader</code>
 * 
 * @author xiaoning.qxn
 */
public class ExceptionParser {

	/**
	 * for Protocol.Json2
	 * 
	 * @param exception
	 * @return the new exception
	 * @throws IOException
	 */
	@SuppressWarnings("unchecked")
	public static Throwable buildException4Json2(Map exception) {
		Map<String, Object> m = exception;

		String errorCodeStr = (String) m.get("error_code");
		String errorMesage = (String) m.get("error_message");

		if (errorCodeStr == null) {
			errorCodeStr = (String) m.get("errorCode");
		}

		if (errorMesage == null) {
			errorMesage = (String) m.get("errorMessage");
		}

		// if null ,then just return the result
		if (GenericsUtil.isBlank(errorMesage)) {
			errorMesage = "Unknow message defined in response.";
		}
		return buildException(errorCodeStr, errorMesage);
	}

	@SuppressWarnings("unchecked")
	public static Throwable buildException4OAuth2(Map exception) {
		Map<String, Object> m = exception;
		int errorCode = 401;
		String errorMessage = (String) m.get("error_description");
		return buildException(errorCode, errorMessage);
	}

	private static Throwable buildException(int errorCode, String errorMesage) {

		return new OceanException(String.valueOf(errorCode), errorMesage);
	}

	private static Throwable buildException(String errorCode, String errorMesage) {
		return new OceanException(errorCode, errorMesage);
	}
}
